/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sqs.model.TagQueueRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class TagQueueRequestMarshaller
implements Marshaller<Request<TagQueueRequest>, TagQueueRequest> {
    public Request<TagQueueRequest> marshall(TagQueueRequest tagQueueRequest) {
        if (tagQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)tagQueueRequest, "AmazonSQS");
        request.addParameter("Action", "TagQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagQueueRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)tagQueueRequest.getQueueUrl()));
        }
        Map<String, String> tags = tagQueueRequest.getTags();
        int tagsListIndex = 1;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            if (entry != null && entry.getKey() != null) {
                request.addParameter("Tags." + tagsListIndex + ".Key", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry != null && entry.getValue() != null) {
                request.addParameter("Tags." + tagsListIndex + ".Value", StringUtils.fromString((String)entry.getValue()));
            }
            ++tagsListIndex;
        }
        return request;
    }
}

