/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SelectRequestMarshaller
implements Marshaller<Request<SelectRequest>, SelectRequest> {
    public Request<SelectRequest> marshall(SelectRequest selectRequest) {
        if (selectRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)selectRequest, "AmazonSimpleDB");
        request.addParameter("Action", "Select");
        request.addParameter("Version", "2009-04-15");
        if (selectRequest.getSelectExpression() != null) {
            request.addParameter("SelectExpression", StringUtils.fromString((String)selectRequest.getSelectExpression()));
        }
        if (selectRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)selectRequest.getNextToken()));
        }
        if (selectRequest.isConsistentRead() != null) {
            request.addParameter("ConsistentRead", StringUtils.fromBoolean((Boolean)selectRequest.isConsistentRead()));
        }
        return request;
    }
}

