/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class SignPayloadResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String jobId;
    private String jobOwner;
    private Map<String, String> metadata;
    private ByteBuffer signature;

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public SignPayloadResult withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setJobOwner(String jobOwner) {
        this.jobOwner = jobOwner;
    }

    public String getJobOwner() {
        return this.jobOwner;
    }

    public SignPayloadResult withJobOwner(String jobOwner) {
        this.setJobOwner(jobOwner);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public SignPayloadResult withMetadata(Map<String, String> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public SignPayloadResult addMetadataEntry(String key, String value) {
        if (null == this.metadata) {
            this.metadata = new HashMap<String, String>();
        }
        if (this.metadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metadata.put(key, value);
        return this;
    }

    public SignPayloadResult clearMetadataEntries() {
        this.metadata = null;
        return this;
    }

    public void setSignature(ByteBuffer signature) {
        this.signature = signature;
    }

    public ByteBuffer getSignature() {
        return this.signature;
    }

    public SignPayloadResult withSignature(ByteBuffer signature) {
        this.setSignature(signature);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getJobOwner() != null) {
            sb.append("JobOwner: ").append(this.getJobOwner()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata()).append(",");
        }
        if (this.getSignature() != null) {
            sb.append("Signature: ").append(this.getSignature());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignPayloadResult)) {
            return false;
        }
        SignPayloadResult other = (SignPayloadResult)obj;
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getJobOwner() == null ^ this.getJobOwner() == null) {
            return false;
        }
        if (other.getJobOwner() != null && !other.getJobOwner().equals(this.getJobOwner())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getSignature() == null ^ this.getSignature() == null) {
            return false;
        }
        return other.getSignature() == null || other.getSignature().equals(this.getSignature());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getJobOwner() == null ? 0 : this.getJobOwner().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getSignature() == null ? 0 : this.getSignature().hashCode());
        return hashCode;
    }

    public SignPayloadResult clone() {
        try {
            return (SignPayloadResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

