/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.signer.model.ImageFormat;
import com.amazonaws.services.signer.model.transform.SigningImageFormatMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SigningImageFormat
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> supportedFormats;
    private String defaultFormat;

    public List<String> getSupportedFormats() {
        return this.supportedFormats;
    }

    public void setSupportedFormats(Collection<String> supportedFormats) {
        if (supportedFormats == null) {
            this.supportedFormats = null;
            return;
        }
        this.supportedFormats = new ArrayList<String>(supportedFormats);
    }

    public SigningImageFormat withSupportedFormats(String ... supportedFormats) {
        if (this.supportedFormats == null) {
            this.setSupportedFormats(new ArrayList<String>(supportedFormats.length));
        }
        for (String ele : supportedFormats) {
            this.supportedFormats.add(ele);
        }
        return this;
    }

    public SigningImageFormat withSupportedFormats(Collection<String> supportedFormats) {
        this.setSupportedFormats(supportedFormats);
        return this;
    }

    public SigningImageFormat withSupportedFormats(ImageFormat ... supportedFormats) {
        ArrayList<String> supportedFormatsCopy = new ArrayList<String>(supportedFormats.length);
        for (ImageFormat value : supportedFormats) {
            supportedFormatsCopy.add(value.toString());
        }
        if (this.getSupportedFormats() == null) {
            this.setSupportedFormats(supportedFormatsCopy);
        } else {
            this.getSupportedFormats().addAll(supportedFormatsCopy);
        }
        return this;
    }

    public void setDefaultFormat(String defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public SigningImageFormat withDefaultFormat(String defaultFormat) {
        this.setDefaultFormat(defaultFormat);
        return this;
    }

    public SigningImageFormat withDefaultFormat(ImageFormat defaultFormat) {
        this.defaultFormat = defaultFormat.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSupportedFormats() != null) {
            sb.append("SupportedFormats: ").append(this.getSupportedFormats()).append(",");
        }
        if (this.getDefaultFormat() != null) {
            sb.append("DefaultFormat: ").append(this.getDefaultFormat());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningImageFormat)) {
            return false;
        }
        SigningImageFormat other = (SigningImageFormat)obj;
        if (other.getSupportedFormats() == null ^ this.getSupportedFormats() == null) {
            return false;
        }
        if (other.getSupportedFormats() != null && !other.getSupportedFormats().equals(this.getSupportedFormats())) {
            return false;
        }
        if (other.getDefaultFormat() == null ^ this.getDefaultFormat() == null) {
            return false;
        }
        return other.getDefaultFormat() == null || other.getDefaultFormat().equals(this.getDefaultFormat());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSupportedFormats() == null ? 0 : this.getSupportedFormats().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultFormat() == null ? 0 : this.getDefaultFormat().hashCode());
        return hashCode;
    }

    public SigningImageFormat clone() {
        try {
            return (SigningImageFormat)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SigningImageFormatMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

