/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.DkimSigningKeyLength;
import com.amazonaws.services.simpleemailv2.model.transform.DkimSigningAttributesMarshaller;
import java.io.Serializable;

public class DkimSigningAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private String domainSigningSelector;
    private String domainSigningPrivateKey;
    private String nextSigningKeyLength;

    public void setDomainSigningSelector(String domainSigningSelector) {
        this.domainSigningSelector = domainSigningSelector;
    }

    public String getDomainSigningSelector() {
        return this.domainSigningSelector;
    }

    public DkimSigningAttributes withDomainSigningSelector(String domainSigningSelector) {
        this.setDomainSigningSelector(domainSigningSelector);
        return this;
    }

    public void setDomainSigningPrivateKey(String domainSigningPrivateKey) {
        this.domainSigningPrivateKey = domainSigningPrivateKey;
    }

    public String getDomainSigningPrivateKey() {
        return this.domainSigningPrivateKey;
    }

    public DkimSigningAttributes withDomainSigningPrivateKey(String domainSigningPrivateKey) {
        this.setDomainSigningPrivateKey(domainSigningPrivateKey);
        return this;
    }

    public void setNextSigningKeyLength(String nextSigningKeyLength) {
        this.nextSigningKeyLength = nextSigningKeyLength;
    }

    public String getNextSigningKeyLength() {
        return this.nextSigningKeyLength;
    }

    public DkimSigningAttributes withNextSigningKeyLength(String nextSigningKeyLength) {
        this.setNextSigningKeyLength(nextSigningKeyLength);
        return this;
    }

    public DkimSigningAttributes withNextSigningKeyLength(DkimSigningKeyLength nextSigningKeyLength) {
        this.nextSigningKeyLength = nextSigningKeyLength.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainSigningSelector() != null) {
            sb.append("DomainSigningSelector: ").append(this.getDomainSigningSelector()).append(",");
        }
        if (this.getDomainSigningPrivateKey() != null) {
            sb.append("DomainSigningPrivateKey: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getNextSigningKeyLength() != null) {
            sb.append("NextSigningKeyLength: ").append(this.getNextSigningKeyLength());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DkimSigningAttributes)) {
            return false;
        }
        DkimSigningAttributes other = (DkimSigningAttributes)obj;
        if (other.getDomainSigningSelector() == null ^ this.getDomainSigningSelector() == null) {
            return false;
        }
        if (other.getDomainSigningSelector() != null && !other.getDomainSigningSelector().equals(this.getDomainSigningSelector())) {
            return false;
        }
        if (other.getDomainSigningPrivateKey() == null ^ this.getDomainSigningPrivateKey() == null) {
            return false;
        }
        if (other.getDomainSigningPrivateKey() != null && !other.getDomainSigningPrivateKey().equals(this.getDomainSigningPrivateKey())) {
            return false;
        }
        if (other.getNextSigningKeyLength() == null ^ this.getNextSigningKeyLength() == null) {
            return false;
        }
        return other.getNextSigningKeyLength() == null || other.getNextSigningKeyLength().equals(this.getNextSigningKeyLength());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainSigningSelector() == null ? 0 : this.getDomainSigningSelector().hashCode());
        hashCode = 31 * hashCode + (this.getDomainSigningPrivateKey() == null ? 0 : this.getDomainSigningPrivateKey().hashCode());
        hashCode = 31 * hashCode + (this.getNextSigningKeyLength() == null ? 0 : this.getNextSigningKeyLength().hashCode());
        return hashCode;
    }

    public DkimSigningAttributes clone() {
        try {
            return (DkimSigningAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DkimSigningAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

