/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.servermigration.model.ReplicationJob;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ReplicationJobMarshaller {
    private static final MarshallingInfo<String> REPLICATIONJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationJobId").build();
    private static final MarshallingInfo<String> SERVERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverId").build();
    private static final MarshallingInfo<String> SERVERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverType").build();
    private static final MarshallingInfo<StructuredPojo> VMSERVER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmServer").build();
    private static final MarshallingInfo<Date> SEEDREPLICATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("seedReplicationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> FREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frequency").build();
    private static final MarshallingInfo<Boolean> RUNONCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("runOnce").build();
    private static final MarshallingInfo<Date> NEXTREPLICATIONRUNSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextReplicationRunStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> LICENSETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseType").build();
    private static final MarshallingInfo<String> ROLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleName").build();
    private static final MarshallingInfo<String> LATESTAMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestAmiId").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusMessage").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Integer> NUMBEROFRECENTAMISTOKEEP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfRecentAmisToKeep").build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encrypted").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyId").build();
    private static final MarshallingInfo<List> REPLICATIONRUNLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationRunList").build();
    private static final ReplicationJobMarshaller instance = new ReplicationJobMarshaller();

    public static ReplicationJobMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReplicationJob replicationJob, ProtocolMarshaller protocolMarshaller) {
        if (replicationJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)replicationJob.getReplicationJobId(), REPLICATIONJOBID_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getServerId(), SERVERID_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getServerType(), SERVERTYPE_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getVmServer(), VMSERVER_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getSeedReplicationTime(), SEEDREPLICATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getFrequency(), FREQUENCY_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getRunOnce(), RUNONCE_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getNextReplicationRunStartTime(), NEXTREPLICATIONRUNSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getLicenseType(), LICENSETYPE_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getRoleName(), ROLENAME_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getLatestAmiId(), LATESTAMIID_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getStatusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getNumberOfRecentAmisToKeep(), NUMBEROFRECENTAMISTOKEEP_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getEncrypted(), ENCRYPTED_BINDING);
            protocolMarshaller.marshall((Object)replicationJob.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall(replicationJob.getReplicationRunList(), REPLICATIONRUNLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

