/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securityhub.model.ParameterConfiguration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UpdateSecurityControlRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String securityControlId;
    private Map<String, ParameterConfiguration> parameters;
    private String lastUpdateReason;

    public void setSecurityControlId(String securityControlId) {
        this.securityControlId = securityControlId;
    }

    public String getSecurityControlId() {
        return this.securityControlId;
    }

    public UpdateSecurityControlRequest withSecurityControlId(String securityControlId) {
        this.setSecurityControlId(securityControlId);
        return this;
    }

    public Map<String, ParameterConfiguration> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, ParameterConfiguration> parameters) {
        this.parameters = parameters;
    }

    public UpdateSecurityControlRequest withParameters(Map<String, ParameterConfiguration> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public UpdateSecurityControlRequest addParametersEntry(String key, ParameterConfiguration value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, ParameterConfiguration>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public UpdateSecurityControlRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setLastUpdateReason(String lastUpdateReason) {
        this.lastUpdateReason = lastUpdateReason;
    }

    public String getLastUpdateReason() {
        return this.lastUpdateReason;
    }

    public UpdateSecurityControlRequest withLastUpdateReason(String lastUpdateReason) {
        this.setLastUpdateReason(lastUpdateReason);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityControlId() != null) {
            sb.append("SecurityControlId: ").append(this.getSecurityControlId()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getLastUpdateReason() != null) {
            sb.append("LastUpdateReason: ").append(this.getLastUpdateReason());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityControlRequest)) {
            return false;
        }
        UpdateSecurityControlRequest other = (UpdateSecurityControlRequest)obj;
        if (other.getSecurityControlId() == null ^ this.getSecurityControlId() == null) {
            return false;
        }
        if (other.getSecurityControlId() != null && !other.getSecurityControlId().equals(this.getSecurityControlId())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getLastUpdateReason() == null ^ this.getLastUpdateReason() == null) {
            return false;
        }
        return other.getLastUpdateReason() == null || other.getLastUpdateReason().equals(this.getLastUpdateReason());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityControlId() == null ? 0 : this.getSecurityControlId().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateReason() == null ? 0 : this.getLastUpdateReason().hashCode());
        return hashCode;
    }

    public UpdateSecurityControlRequest clone() {
        return (UpdateSecurityControlRequest)super.clone();
    }
}

