/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.Action;

@SdkInternalApi
public class ActionMarshaller {
    private static final MarshallingInfo<String> ACTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionType").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKCONNECTIONACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetworkConnectionAction").build();
    private static final MarshallingInfo<StructuredPojo> AWSAPICALLACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsApiCallAction").build();
    private static final MarshallingInfo<StructuredPojo> DNSREQUESTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsRequestAction").build();
    private static final MarshallingInfo<StructuredPojo> PORTPROBEACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PortProbeAction").build();
    private static final ActionMarshaller instance = new ActionMarshaller();

    public static ActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Action action, ProtocolMarshaller protocolMarshaller) {
        if (action == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)action.getActionType(), ACTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)action.getNetworkConnectionAction(), NETWORKCONNECTIONACTION_BINDING);
            protocolMarshaller.marshall((Object)action.getAwsApiCallAction(), AWSAPICALLACTION_BINDING);
            protocolMarshaller.marshall((Object)action.getDnsRequestAction(), DNSREQUESTACTION_BINDING);
            protocolMarshaller.marshall((Object)action.getPortProbeAction(), PORTPROBEACTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

