/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.transform.EnumConfigurationOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnumConfigurationOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String defaultValue;
    private List<String> allowedValues;

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public EnumConfigurationOptions withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(Collection<String> allowedValues) {
        if (allowedValues == null) {
            this.allowedValues = null;
            return;
        }
        this.allowedValues = new ArrayList<String>(allowedValues);
    }

    public EnumConfigurationOptions withAllowedValues(String ... allowedValues) {
        if (this.allowedValues == null) {
            this.setAllowedValues(new ArrayList<String>(allowedValues.length));
        }
        for (String ele : allowedValues) {
            this.allowedValues.add(ele);
        }
        return this;
    }

    public EnumConfigurationOptions withAllowedValues(Collection<String> allowedValues) {
        this.setAllowedValues(allowedValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getAllowedValues() != null) {
            sb.append("AllowedValues: ").append(this.getAllowedValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumConfigurationOptions)) {
            return false;
        }
        EnumConfigurationOptions other = (EnumConfigurationOptions)obj;
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getAllowedValues() == null ^ this.getAllowedValues() == null) {
            return false;
        }
        return other.getAllowedValues() == null || other.getAllowedValues().equals(this.getAllowedValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedValues() == null ? 0 : this.getAllowedValues().hashCode());
        return hashCode;
    }

    public EnumConfigurationOptions clone() {
        try {
            return (EnumConfigurationOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnumConfigurationOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

