/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.NetworkPathComponent;

@SdkInternalApi
public class NetworkPathComponentMarshaller {
    private static final MarshallingInfo<String> COMPONENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComponentId").build();
    private static final MarshallingInfo<String> COMPONENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComponentType").build();
    private static final MarshallingInfo<StructuredPojo> EGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Egress").build();
    private static final MarshallingInfo<StructuredPojo> INGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ingress").build();
    private static final NetworkPathComponentMarshaller instance = new NetworkPathComponentMarshaller();

    public static NetworkPathComponentMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkPathComponent networkPathComponent, ProtocolMarshaller protocolMarshaller) {
        if (networkPathComponent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)networkPathComponent.getComponentId(), COMPONENTID_BINDING);
            protocolMarshaller.marshall((Object)networkPathComponent.getComponentType(), COMPONENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)networkPathComponent.getEgress(), EGRESS_BINDING);
            protocolMarshaller.marshall((Object)networkPathComponent.getIngress(), INGRESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

