/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakerfeaturestoreruntime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemakerfeaturestoreruntime.model.TargetStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeleteRecordRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String featureGroupName;
    private String recordIdentifierValueAsString;
    private String eventTime;
    private List<String> targetStores;

    public void setFeatureGroupName(String featureGroupName) {
        this.featureGroupName = featureGroupName;
    }

    public String getFeatureGroupName() {
        return this.featureGroupName;
    }

    public DeleteRecordRequest withFeatureGroupName(String featureGroupName) {
        this.setFeatureGroupName(featureGroupName);
        return this;
    }

    public void setRecordIdentifierValueAsString(String recordIdentifierValueAsString) {
        this.recordIdentifierValueAsString = recordIdentifierValueAsString;
    }

    public String getRecordIdentifierValueAsString() {
        return this.recordIdentifierValueAsString;
    }

    public DeleteRecordRequest withRecordIdentifierValueAsString(String recordIdentifierValueAsString) {
        this.setRecordIdentifierValueAsString(recordIdentifierValueAsString);
        return this;
    }

    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public String getEventTime() {
        return this.eventTime;
    }

    public DeleteRecordRequest withEventTime(String eventTime) {
        this.setEventTime(eventTime);
        return this;
    }

    public List<String> getTargetStores() {
        return this.targetStores;
    }

    public void setTargetStores(Collection<String> targetStores) {
        if (targetStores == null) {
            this.targetStores = null;
            return;
        }
        this.targetStores = new ArrayList<String>(targetStores);
    }

    public DeleteRecordRequest withTargetStores(String ... targetStores) {
        if (this.targetStores == null) {
            this.setTargetStores(new ArrayList<String>(targetStores.length));
        }
        for (String ele : targetStores) {
            this.targetStores.add(ele);
        }
        return this;
    }

    public DeleteRecordRequest withTargetStores(Collection<String> targetStores) {
        this.setTargetStores(targetStores);
        return this;
    }

    public DeleteRecordRequest withTargetStores(TargetStore ... targetStores) {
        ArrayList<String> targetStoresCopy = new ArrayList<String>(targetStores.length);
        for (TargetStore value : targetStores) {
            targetStoresCopy.add(value.toString());
        }
        if (this.getTargetStores() == null) {
            this.setTargetStores(targetStoresCopy);
        } else {
            this.getTargetStores().addAll(targetStoresCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFeatureGroupName() != null) {
            sb.append("FeatureGroupName: ").append(this.getFeatureGroupName()).append(",");
        }
        if (this.getRecordIdentifierValueAsString() != null) {
            sb.append("RecordIdentifierValueAsString: ").append(this.getRecordIdentifierValueAsString()).append(",");
        }
        if (this.getEventTime() != null) {
            sb.append("EventTime: ").append(this.getEventTime()).append(",");
        }
        if (this.getTargetStores() != null) {
            sb.append("TargetStores: ").append(this.getTargetStores());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecordRequest)) {
            return false;
        }
        DeleteRecordRequest other = (DeleteRecordRequest)obj;
        if (other.getFeatureGroupName() == null ^ this.getFeatureGroupName() == null) {
            return false;
        }
        if (other.getFeatureGroupName() != null && !other.getFeatureGroupName().equals(this.getFeatureGroupName())) {
            return false;
        }
        if (other.getRecordIdentifierValueAsString() == null ^ this.getRecordIdentifierValueAsString() == null) {
            return false;
        }
        if (other.getRecordIdentifierValueAsString() != null && !other.getRecordIdentifierValueAsString().equals(this.getRecordIdentifierValueAsString())) {
            return false;
        }
        if (other.getEventTime() == null ^ this.getEventTime() == null) {
            return false;
        }
        if (other.getEventTime() != null && !other.getEventTime().equals(this.getEventTime())) {
            return false;
        }
        if (other.getTargetStores() == null ^ this.getTargetStores() == null) {
            return false;
        }
        return other.getTargetStores() == null || other.getTargetStores().equals(this.getTargetStores());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFeatureGroupName() == null ? 0 : this.getFeatureGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getRecordIdentifierValueAsString() == null ? 0 : this.getRecordIdentifierValueAsString().hashCode());
        hashCode = 31 * hashCode + (this.getEventTime() == null ? 0 : this.getEventTime().hashCode());
        hashCode = 31 * hashCode + (this.getTargetStores() == null ? 0 : this.getTargetStores().hashCode());
        return hashCode;
    }

    public DeleteRecordRequest clone() {
        return (DeleteRecordRequest)super.clone();
    }
}

