/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.ListRegionalBucketsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListRegionalBucketsRequestMarshaller
implements Marshaller<Request<ListRegionalBucketsRequest>, ListRegionalBucketsRequest> {
    public Request<ListRegionalBucketsRequest> marshall(ListRegionalBucketsRequest listRegionalBucketsRequest) {
        if (listRegionalBucketsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRegionalBucketsRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (listRegionalBucketsRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)listRegionalBucketsRequest.getAccountId()));
        }
        if (listRegionalBucketsRequest.getOutpostId() != null) {
            request.addHeader("x-amz-outpost-id", StringUtils.fromString((String)listRegionalBucketsRequest.getOutpostId()));
        }
        String uriResourcePath = "/v20180820/bucket";
        request.setResourcePath(uriResourcePath);
        if (listRegionalBucketsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listRegionalBucketsRequest.getNextToken()));
        }
        if (listRegionalBucketsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listRegionalBucketsRequest.getMaxResults()));
        }
        return request;
    }
}

