/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.JobManifestFieldName;
import com.amazonaws.services.s3control.model.JobManifestFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JobManifestSpec
implements Serializable,
Cloneable {
    private String format;
    private List<String> fields;

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public JobManifestSpec withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public JobManifestSpec withFormat(JobManifestFormat format) {
        this.format = format.toString();
        return this;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(Collection<String> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new ArrayList<String>(fields);
    }

    public JobManifestSpec withFields(String ... fields) {
        if (this.fields == null) {
            this.setFields(new ArrayList<String>(fields.length));
        }
        for (String ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public JobManifestSpec withFields(Collection<String> fields) {
        this.setFields(fields);
        return this;
    }

    public JobManifestSpec withFields(JobManifestFieldName ... fields) {
        ArrayList<String> fieldsCopy = new ArrayList<String>(fields.length);
        for (JobManifestFieldName value : fields) {
            fieldsCopy.add(value.toString());
        }
        if (this.getFields() == null) {
            this.setFields(fieldsCopy);
        } else {
            this.getFields().addAll(fieldsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobManifestSpec)) {
            return false;
        }
        JobManifestSpec other = (JobManifestSpec)obj;
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        return other.getFields() == null || other.getFields().equals(this.getFields());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        return hashCode;
    }

    public JobManifestSpec clone() {
        try {
            return (JobManifestSpec)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

