/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3control.model.StorageLensGroup;
import com.amazonaws.services.s3control.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateStorageLensGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String accountId;
    private StorageLensGroup storageLensGroup;
    private List<Tag> tags;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public CreateStorageLensGroupRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setStorageLensGroup(StorageLensGroup storageLensGroup) {
        this.storageLensGroup = storageLensGroup;
    }

    public StorageLensGroup getStorageLensGroup() {
        return this.storageLensGroup;
    }

    public CreateStorageLensGroupRequest withStorageLensGroup(StorageLensGroup storageLensGroup) {
        this.setStorageLensGroup(storageLensGroup);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateStorageLensGroupRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateStorageLensGroupRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getStorageLensGroup() != null) {
            sb.append("StorageLensGroup: ").append(this.getStorageLensGroup()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorageLensGroupRequest)) {
            return false;
        }
        CreateStorageLensGroupRequest other = (CreateStorageLensGroupRequest)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getStorageLensGroup() == null ^ this.getStorageLensGroup() == null) {
            return false;
        }
        if (other.getStorageLensGroup() != null && !other.getStorageLensGroup().equals(this.getStorageLensGroup())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getStorageLensGroup() == null ? 0 : this.getStorageLensGroup().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateStorageLensGroupRequest clone() {
        return (CreateStorageLensGroupRequest)super.clone();
    }
}

