/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.AbortIncompleteMultipartUpload;
import com.amazonaws.services.s3control.model.ExpirationStatus;
import com.amazonaws.services.s3control.model.LifecycleExpiration;
import com.amazonaws.services.s3control.model.LifecycleRuleFilter;
import com.amazonaws.services.s3control.model.NoncurrentVersionExpiration;
import com.amazonaws.services.s3control.model.NoncurrentVersionTransition;
import com.amazonaws.services.s3control.model.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LifecycleRule
implements Serializable,
Cloneable {
    private LifecycleExpiration expiration;
    private String iD;
    private LifecycleRuleFilter filter;
    private String status;
    private List<Transition> transitions;
    private List<NoncurrentVersionTransition> noncurrentVersionTransitions;
    private NoncurrentVersionExpiration noncurrentVersionExpiration;
    private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

    public void setExpiration(LifecycleExpiration expiration) {
        this.expiration = expiration;
    }

    public LifecycleExpiration getExpiration() {
        return this.expiration;
    }

    public LifecycleRule withExpiration(LifecycleExpiration expiration) {
        this.setExpiration(expiration);
        return this;
    }

    public void setID(String iD) {
        this.iD = iD;
    }

    public String getID() {
        return this.iD;
    }

    public LifecycleRule withID(String iD) {
        this.setID(iD);
        return this;
    }

    public void setFilter(LifecycleRuleFilter filter) {
        this.filter = filter;
    }

    public LifecycleRuleFilter getFilter() {
        return this.filter;
    }

    public LifecycleRule withFilter(LifecycleRuleFilter filter) {
        this.setFilter(filter);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public LifecycleRule withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public LifecycleRule withStatus(ExpirationStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(Collection<Transition> transitions) {
        if (transitions == null) {
            this.transitions = null;
            return;
        }
        this.transitions = new ArrayList<Transition>(transitions);
    }

    public LifecycleRule withTransitions(Transition ... transitions) {
        if (this.transitions == null) {
            this.setTransitions(new ArrayList<Transition>(transitions.length));
        }
        for (Transition ele : transitions) {
            this.transitions.add(ele);
        }
        return this;
    }

    public LifecycleRule withTransitions(Collection<Transition> transitions) {
        this.setTransitions(transitions);
        return this;
    }

    public List<NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
        return this.noncurrentVersionTransitions;
    }

    public void setNoncurrentVersionTransitions(Collection<NoncurrentVersionTransition> noncurrentVersionTransitions) {
        if (noncurrentVersionTransitions == null) {
            this.noncurrentVersionTransitions = null;
            return;
        }
        this.noncurrentVersionTransitions = new ArrayList<NoncurrentVersionTransition>(noncurrentVersionTransitions);
    }

    public LifecycleRule withNoncurrentVersionTransitions(NoncurrentVersionTransition ... noncurrentVersionTransitions) {
        if (this.noncurrentVersionTransitions == null) {
            this.setNoncurrentVersionTransitions(new ArrayList<NoncurrentVersionTransition>(noncurrentVersionTransitions.length));
        }
        for (NoncurrentVersionTransition ele : noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions.add(ele);
        }
        return this;
    }

    public LifecycleRule withNoncurrentVersionTransitions(Collection<NoncurrentVersionTransition> noncurrentVersionTransitions) {
        this.setNoncurrentVersionTransitions(noncurrentVersionTransitions);
        return this;
    }

    public void setNoncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
        this.noncurrentVersionExpiration = noncurrentVersionExpiration;
    }

    public NoncurrentVersionExpiration getNoncurrentVersionExpiration() {
        return this.noncurrentVersionExpiration;
    }

    public LifecycleRule withNoncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
        this.setNoncurrentVersionExpiration(noncurrentVersionExpiration);
        return this;
    }

    public void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
        this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
    }

    public AbortIncompleteMultipartUpload getAbortIncompleteMultipartUpload() {
        return this.abortIncompleteMultipartUpload;
    }

    public LifecycleRule withAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
        this.setAbortIncompleteMultipartUpload(abortIncompleteMultipartUpload);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExpiration() != null) {
            sb.append("Expiration: ").append(this.getExpiration()).append(",");
        }
        if (this.getID() != null) {
            sb.append("ID: ").append(this.getID()).append(",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTransitions() != null) {
            sb.append("Transitions: ").append(this.getTransitions()).append(",");
        }
        if (this.getNoncurrentVersionTransitions() != null) {
            sb.append("NoncurrentVersionTransitions: ").append(this.getNoncurrentVersionTransitions()).append(",");
        }
        if (this.getNoncurrentVersionExpiration() != null) {
            sb.append("NoncurrentVersionExpiration: ").append(this.getNoncurrentVersionExpiration()).append(",");
        }
        if (this.getAbortIncompleteMultipartUpload() != null) {
            sb.append("AbortIncompleteMultipartUpload: ").append(this.getAbortIncompleteMultipartUpload());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleRule)) {
            return false;
        }
        LifecycleRule other = (LifecycleRule)obj;
        if (other.getExpiration() == null ^ this.getExpiration() == null) {
            return false;
        }
        if (other.getExpiration() != null && !other.getExpiration().equals(this.getExpiration())) {
            return false;
        }
        if (other.getID() == null ^ this.getID() == null) {
            return false;
        }
        if (other.getID() != null && !other.getID().equals(this.getID())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        if (other.getFilter() != null && !other.getFilter().equals(this.getFilter())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTransitions() == null ^ this.getTransitions() == null) {
            return false;
        }
        if (other.getTransitions() != null && !other.getTransitions().equals(this.getTransitions())) {
            return false;
        }
        if (other.getNoncurrentVersionTransitions() == null ^ this.getNoncurrentVersionTransitions() == null) {
            return false;
        }
        if (other.getNoncurrentVersionTransitions() != null && !other.getNoncurrentVersionTransitions().equals(this.getNoncurrentVersionTransitions())) {
            return false;
        }
        if (other.getNoncurrentVersionExpiration() == null ^ this.getNoncurrentVersionExpiration() == null) {
            return false;
        }
        if (other.getNoncurrentVersionExpiration() != null && !other.getNoncurrentVersionExpiration().equals(this.getNoncurrentVersionExpiration())) {
            return false;
        }
        if (other.getAbortIncompleteMultipartUpload() == null ^ this.getAbortIncompleteMultipartUpload() == null) {
            return false;
        }
        return other.getAbortIncompleteMultipartUpload() == null || other.getAbortIncompleteMultipartUpload().equals(this.getAbortIncompleteMultipartUpload());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExpiration() == null ? 0 : this.getExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getID() == null ? 0 : this.getID().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTransitions() == null ? 0 : this.getTransitions().hashCode());
        hashCode = 31 * hashCode + (this.getNoncurrentVersionTransitions() == null ? 0 : this.getNoncurrentVersionTransitions().hashCode());
        hashCode = 31 * hashCode + (this.getNoncurrentVersionExpiration() == null ? 0 : this.getNoncurrentVersionExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getAbortIncompleteMultipartUpload() == null ? 0 : this.getAbortIncompleteMultipartUpload().hashCode());
        return hashCode;
    }

    public LifecycleRule clone() {
        try {
            return (LifecycleRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

