/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.ContactDetail;
import com.amazonaws.services.route53domains.model.Nameserver;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TransferDomainRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private String idnLangCode;
    private Integer durationInYears;
    private SdkInternalList<Nameserver> nameservers;
    private String authCode;
    private Boolean autoRenew;
    private ContactDetail adminContact;
    private ContactDetail registrantContact;
    private ContactDetail techContact;
    private Boolean privacyProtectAdminContact;
    private Boolean privacyProtectRegistrantContact;
    private Boolean privacyProtectTechContact;
    private ContactDetail billingContact;
    private Boolean privacyProtectBillingContact;

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public TransferDomainRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setIdnLangCode(String idnLangCode) {
        this.idnLangCode = idnLangCode;
    }

    public String getIdnLangCode() {
        return this.idnLangCode;
    }

    public TransferDomainRequest withIdnLangCode(String idnLangCode) {
        this.setIdnLangCode(idnLangCode);
        return this;
    }

    public void setDurationInYears(Integer durationInYears) {
        this.durationInYears = durationInYears;
    }

    public Integer getDurationInYears() {
        return this.durationInYears;
    }

    public TransferDomainRequest withDurationInYears(Integer durationInYears) {
        this.setDurationInYears(durationInYears);
        return this;
    }

    public List<Nameserver> getNameservers() {
        if (this.nameservers == null) {
            this.nameservers = new SdkInternalList();
        }
        return this.nameservers;
    }

    public void setNameservers(Collection<Nameserver> nameservers) {
        if (nameservers == null) {
            this.nameservers = null;
            return;
        }
        this.nameservers = new SdkInternalList(nameservers);
    }

    public TransferDomainRequest withNameservers(Nameserver ... nameservers) {
        if (this.nameservers == null) {
            this.setNameservers((Collection<Nameserver>)new SdkInternalList(nameservers.length));
        }
        for (Nameserver ele : nameservers) {
            this.nameservers.add((Object)ele);
        }
        return this;
    }

    public TransferDomainRequest withNameservers(Collection<Nameserver> nameservers) {
        this.setNameservers(nameservers);
        return this;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public TransferDomainRequest withAuthCode(String authCode) {
        this.setAuthCode(authCode);
        return this;
    }

    public void setAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public Boolean getAutoRenew() {
        return this.autoRenew;
    }

    public TransferDomainRequest withAutoRenew(Boolean autoRenew) {
        this.setAutoRenew(autoRenew);
        return this;
    }

    public Boolean isAutoRenew() {
        return this.autoRenew;
    }

    public void setAdminContact(ContactDetail adminContact) {
        this.adminContact = adminContact;
    }

    public ContactDetail getAdminContact() {
        return this.adminContact;
    }

    public TransferDomainRequest withAdminContact(ContactDetail adminContact) {
        this.setAdminContact(adminContact);
        return this;
    }

    public void setRegistrantContact(ContactDetail registrantContact) {
        this.registrantContact = registrantContact;
    }

    public ContactDetail getRegistrantContact() {
        return this.registrantContact;
    }

    public TransferDomainRequest withRegistrantContact(ContactDetail registrantContact) {
        this.setRegistrantContact(registrantContact);
        return this;
    }

    public void setTechContact(ContactDetail techContact) {
        this.techContact = techContact;
    }

    public ContactDetail getTechContact() {
        return this.techContact;
    }

    public TransferDomainRequest withTechContact(ContactDetail techContact) {
        this.setTechContact(techContact);
        return this;
    }

    public void setPrivacyProtectAdminContact(Boolean privacyProtectAdminContact) {
        this.privacyProtectAdminContact = privacyProtectAdminContact;
    }

    public Boolean getPrivacyProtectAdminContact() {
        return this.privacyProtectAdminContact;
    }

    public TransferDomainRequest withPrivacyProtectAdminContact(Boolean privacyProtectAdminContact) {
        this.setPrivacyProtectAdminContact(privacyProtectAdminContact);
        return this;
    }

    public Boolean isPrivacyProtectAdminContact() {
        return this.privacyProtectAdminContact;
    }

    public void setPrivacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
        this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
    }

    public Boolean getPrivacyProtectRegistrantContact() {
        return this.privacyProtectRegistrantContact;
    }

    public TransferDomainRequest withPrivacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
        this.setPrivacyProtectRegistrantContact(privacyProtectRegistrantContact);
        return this;
    }

    public Boolean isPrivacyProtectRegistrantContact() {
        return this.privacyProtectRegistrantContact;
    }

    public void setPrivacyProtectTechContact(Boolean privacyProtectTechContact) {
        this.privacyProtectTechContact = privacyProtectTechContact;
    }

    public Boolean getPrivacyProtectTechContact() {
        return this.privacyProtectTechContact;
    }

    public TransferDomainRequest withPrivacyProtectTechContact(Boolean privacyProtectTechContact) {
        this.setPrivacyProtectTechContact(privacyProtectTechContact);
        return this;
    }

    public Boolean isPrivacyProtectTechContact() {
        return this.privacyProtectTechContact;
    }

    public void setBillingContact(ContactDetail billingContact) {
        this.billingContact = billingContact;
    }

    public ContactDetail getBillingContact() {
        return this.billingContact;
    }

    public TransferDomainRequest withBillingContact(ContactDetail billingContact) {
        this.setBillingContact(billingContact);
        return this;
    }

    public void setPrivacyProtectBillingContact(Boolean privacyProtectBillingContact) {
        this.privacyProtectBillingContact = privacyProtectBillingContact;
    }

    public Boolean getPrivacyProtectBillingContact() {
        return this.privacyProtectBillingContact;
    }

    public TransferDomainRequest withPrivacyProtectBillingContact(Boolean privacyProtectBillingContact) {
        this.setPrivacyProtectBillingContact(privacyProtectBillingContact);
        return this;
    }

    public Boolean isPrivacyProtectBillingContact() {
        return this.privacyProtectBillingContact;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getIdnLangCode() != null) {
            sb.append("IdnLangCode: ").append(this.getIdnLangCode()).append(",");
        }
        if (this.getDurationInYears() != null) {
            sb.append("DurationInYears: ").append(this.getDurationInYears()).append(",");
        }
        if (this.getNameservers() != null) {
            sb.append("Nameservers: ").append(this.getNameservers()).append(",");
        }
        if (this.getAuthCode() != null) {
            sb.append("AuthCode: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAutoRenew() != null) {
            sb.append("AutoRenew: ").append(this.getAutoRenew()).append(",");
        }
        if (this.getAdminContact() != null) {
            sb.append("AdminContact: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getRegistrantContact() != null) {
            sb.append("RegistrantContact: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTechContact() != null) {
            sb.append("TechContact: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPrivacyProtectAdminContact() != null) {
            sb.append("PrivacyProtectAdminContact: ").append(this.getPrivacyProtectAdminContact()).append(",");
        }
        if (this.getPrivacyProtectRegistrantContact() != null) {
            sb.append("PrivacyProtectRegistrantContact: ").append(this.getPrivacyProtectRegistrantContact()).append(",");
        }
        if (this.getPrivacyProtectTechContact() != null) {
            sb.append("PrivacyProtectTechContact: ").append(this.getPrivacyProtectTechContact()).append(",");
        }
        if (this.getBillingContact() != null) {
            sb.append("BillingContact: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPrivacyProtectBillingContact() != null) {
            sb.append("PrivacyProtectBillingContact: ").append(this.getPrivacyProtectBillingContact());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferDomainRequest)) {
            return false;
        }
        TransferDomainRequest other = (TransferDomainRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getIdnLangCode() == null ^ this.getIdnLangCode() == null) {
            return false;
        }
        if (other.getIdnLangCode() != null && !other.getIdnLangCode().equals(this.getIdnLangCode())) {
            return false;
        }
        if (other.getDurationInYears() == null ^ this.getDurationInYears() == null) {
            return false;
        }
        if (other.getDurationInYears() != null && !other.getDurationInYears().equals(this.getDurationInYears())) {
            return false;
        }
        if (other.getNameservers() == null ^ this.getNameservers() == null) {
            return false;
        }
        if (other.getNameservers() != null && !other.getNameservers().equals(this.getNameservers())) {
            return false;
        }
        if (other.getAuthCode() == null ^ this.getAuthCode() == null) {
            return false;
        }
        if (other.getAuthCode() != null && !other.getAuthCode().equals(this.getAuthCode())) {
            return false;
        }
        if (other.getAutoRenew() == null ^ this.getAutoRenew() == null) {
            return false;
        }
        if (other.getAutoRenew() != null && !other.getAutoRenew().equals(this.getAutoRenew())) {
            return false;
        }
        if (other.getAdminContact() == null ^ this.getAdminContact() == null) {
            return false;
        }
        if (other.getAdminContact() != null && !other.getAdminContact().equals(this.getAdminContact())) {
            return false;
        }
        if (other.getRegistrantContact() == null ^ this.getRegistrantContact() == null) {
            return false;
        }
        if (other.getRegistrantContact() != null && !other.getRegistrantContact().equals(this.getRegistrantContact())) {
            return false;
        }
        if (other.getTechContact() == null ^ this.getTechContact() == null) {
            return false;
        }
        if (other.getTechContact() != null && !other.getTechContact().equals(this.getTechContact())) {
            return false;
        }
        if (other.getPrivacyProtectAdminContact() == null ^ this.getPrivacyProtectAdminContact() == null) {
            return false;
        }
        if (other.getPrivacyProtectAdminContact() != null && !other.getPrivacyProtectAdminContact().equals(this.getPrivacyProtectAdminContact())) {
            return false;
        }
        if (other.getPrivacyProtectRegistrantContact() == null ^ this.getPrivacyProtectRegistrantContact() == null) {
            return false;
        }
        if (other.getPrivacyProtectRegistrantContact() != null && !other.getPrivacyProtectRegistrantContact().equals(this.getPrivacyProtectRegistrantContact())) {
            return false;
        }
        if (other.getPrivacyProtectTechContact() == null ^ this.getPrivacyProtectTechContact() == null) {
            return false;
        }
        if (other.getPrivacyProtectTechContact() != null && !other.getPrivacyProtectTechContact().equals(this.getPrivacyProtectTechContact())) {
            return false;
        }
        if (other.getBillingContact() == null ^ this.getBillingContact() == null) {
            return false;
        }
        if (other.getBillingContact() != null && !other.getBillingContact().equals(this.getBillingContact())) {
            return false;
        }
        if (other.getPrivacyProtectBillingContact() == null ^ this.getPrivacyProtectBillingContact() == null) {
            return false;
        }
        return other.getPrivacyProtectBillingContact() == null || other.getPrivacyProtectBillingContact().equals(this.getPrivacyProtectBillingContact());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getIdnLangCode() == null ? 0 : this.getIdnLangCode().hashCode());
        hashCode = 31 * hashCode + (this.getDurationInYears() == null ? 0 : this.getDurationInYears().hashCode());
        hashCode = 31 * hashCode + (this.getNameservers() == null ? 0 : this.getNameservers().hashCode());
        hashCode = 31 * hashCode + (this.getAuthCode() == null ? 0 : this.getAuthCode().hashCode());
        hashCode = 31 * hashCode + (this.getAutoRenew() == null ? 0 : this.getAutoRenew().hashCode());
        hashCode = 31 * hashCode + (this.getAdminContact() == null ? 0 : this.getAdminContact().hashCode());
        hashCode = 31 * hashCode + (this.getRegistrantContact() == null ? 0 : this.getRegistrantContact().hashCode());
        hashCode = 31 * hashCode + (this.getTechContact() == null ? 0 : this.getTechContact().hashCode());
        hashCode = 31 * hashCode + (this.getPrivacyProtectAdminContact() == null ? 0 : this.getPrivacyProtectAdminContact().hashCode());
        hashCode = 31 * hashCode + (this.getPrivacyProtectRegistrantContact() == null ? 0 : this.getPrivacyProtectRegistrantContact().hashCode());
        hashCode = 31 * hashCode + (this.getPrivacyProtectTechContact() == null ? 0 : this.getPrivacyProtectTechContact().hashCode());
        hashCode = 31 * hashCode + (this.getBillingContact() == null ? 0 : this.getBillingContact().hashCode());
        hashCode = 31 * hashCode + (this.getPrivacyProtectBillingContact() == null ? 0 : this.getPrivacyProtectBillingContact().hashCode());
        return hashCode;
    }

    public TransferDomainRequest clone() {
        return (TransferDomainRequest)super.clone();
    }
}

