/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.resourcegroups.model.ListGroupResourcesItem;
import com.amazonaws.services.resourcegroups.model.QueryError;
import com.amazonaws.services.resourcegroups.model.ResourceIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListGroupResourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ListGroupResourcesItem> resources;
    @Deprecated
    private List<ResourceIdentifier> resourceIdentifiers;
    private String nextToken;
    private List<QueryError> queryErrors;

    public List<ListGroupResourcesItem> getResources() {
        return this.resources;
    }

    public void setResources(Collection<ListGroupResourcesItem> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<ListGroupResourcesItem>(resources);
    }

    public ListGroupResourcesResult withResources(ListGroupResourcesItem ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<ListGroupResourcesItem>(resources.length));
        }
        for (ListGroupResourcesItem ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public ListGroupResourcesResult withResources(Collection<ListGroupResourcesItem> resources) {
        this.setResources(resources);
        return this;
    }

    @Deprecated
    public List<ResourceIdentifier> getResourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    @Deprecated
    public void setResourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            this.resourceIdentifiers = null;
            return;
        }
        this.resourceIdentifiers = new ArrayList<ResourceIdentifier>(resourceIdentifiers);
    }

    @Deprecated
    public ListGroupResourcesResult withResourceIdentifiers(ResourceIdentifier ... resourceIdentifiers) {
        if (this.resourceIdentifiers == null) {
            this.setResourceIdentifiers(new ArrayList<ResourceIdentifier>(resourceIdentifiers.length));
        }
        for (ResourceIdentifier ele : resourceIdentifiers) {
            this.resourceIdentifiers.add(ele);
        }
        return this;
    }

    @Deprecated
    public ListGroupResourcesResult withResourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
        this.setResourceIdentifiers(resourceIdentifiers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListGroupResourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<QueryError> getQueryErrors() {
        return this.queryErrors;
    }

    public void setQueryErrors(Collection<QueryError> queryErrors) {
        if (queryErrors == null) {
            this.queryErrors = null;
            return;
        }
        this.queryErrors = new ArrayList<QueryError>(queryErrors);
    }

    public ListGroupResourcesResult withQueryErrors(QueryError ... queryErrors) {
        if (this.queryErrors == null) {
            this.setQueryErrors(new ArrayList<QueryError>(queryErrors.length));
        }
        for (QueryError ele : queryErrors) {
            this.queryErrors.add(ele);
        }
        return this;
    }

    public ListGroupResourcesResult withQueryErrors(Collection<QueryError> queryErrors) {
        this.setQueryErrors(queryErrors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getResourceIdentifiers() != null) {
            sb.append("ResourceIdentifiers: ").append(this.getResourceIdentifiers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getQueryErrors() != null) {
            sb.append("QueryErrors: ").append(this.getQueryErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupResourcesResult)) {
            return false;
        }
        ListGroupResourcesResult other = (ListGroupResourcesResult)obj;
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getResourceIdentifiers() == null ^ this.getResourceIdentifiers() == null) {
            return false;
        }
        if (other.getResourceIdentifiers() != null && !other.getResourceIdentifiers().equals(this.getResourceIdentifiers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getQueryErrors() == null ^ this.getQueryErrors() == null) {
            return false;
        }
        return other.getQueryErrors() == null || other.getQueryErrors().equals(this.getQueryErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIdentifiers() == null ? 0 : this.getResourceIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getQueryErrors() == null ? 0 : this.getQueryErrors().hashCode());
        return hashCode;
    }

    public ListGroupResourcesResult clone() {
        try {
            return (ListGroupResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

