/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListViewsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<String> views;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListViewsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getViews() {
        return this.views;
    }

    public void setViews(Collection<String> views) {
        if (views == null) {
            this.views = null;
            return;
        }
        this.views = new ArrayList<String>(views);
    }

    public ListViewsResult withViews(String ... views) {
        if (this.views == null) {
            this.setViews(new ArrayList<String>(views.length));
        }
        for (String ele : views) {
            this.views.add(ele);
        }
        return this;
    }

    public ListViewsResult withViews(Collection<String> views) {
        this.setViews(views);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getViews() != null) {
            sb.append("Views: ").append(this.getViews());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListViewsResult)) {
            return false;
        }
        ListViewsResult other = (ListViewsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getViews() == null ^ this.getViews() == null) {
            return false;
        }
        return other.getViews() == null || other.getViews().equals(this.getViews());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getViews() == null ? 0 : this.getViews().hashCode());
        return hashCode;
    }

    public ListViewsResult clone() {
        try {
            return (ListViewsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

