/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftdataapi.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.redshiftdataapi.model.StatementData;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class StatementDataMarshaller {
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<Boolean> ISBATCHSTATEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsBatchStatement").build();
    private static final MarshallingInfo<List> QUERYPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryParameters").build();
    private static final MarshallingInfo<String> QUERYSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryString").build();
    private static final MarshallingInfo<List> QUERYSTRINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryStrings").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretArn").build();
    private static final MarshallingInfo<String> STATEMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatementName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedAt").timestampFormat("unixTimestamp").build();
    private static final StatementDataMarshaller instance = new StatementDataMarshaller();

    public static StatementDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(StatementData statementData, ProtocolMarshaller protocolMarshaller) {
        if (statementData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)statementData.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)statementData.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)statementData.getIsBatchStatement(), ISBATCHSTATEMENT_BINDING);
            protocolMarshaller.marshall(statementData.getQueryParameters(), QUERYPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)statementData.getQueryString(), QUERYSTRING_BINDING);
            protocolMarshaller.marshall(statementData.getQueryStrings(), QUERYSTRINGS_BINDING);
            protocolMarshaller.marshall((Object)statementData.getSecretArn(), SECRETARN_BINDING);
            protocolMarshaller.marshall((Object)statementData.getStatementName(), STATEMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)statementData.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)statementData.getUpdatedAt(), UPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

