/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.RecommendedAction;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RecommendedActionStaxUnmarshaller
implements Unmarshaller<RecommendedAction, StaxUnmarshallerContext> {
    private static RecommendedActionStaxUnmarshaller instance;

    public RecommendedAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        RecommendedAction recommendedAction = new RecommendedAction();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return recommendedAction;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Text", targetDepth)) {
                    recommendedAction.setText(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Database", targetDepth)) {
                    recommendedAction.setDatabase(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Command", targetDepth)) {
                    recommendedAction.setCommand(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Type", targetDepth)) continue;
                recommendedAction.setType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return recommendedAction;
    }

    public static RecommendedActionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RecommendedActionStaxUnmarshaller();
        }
        return instance;
    }
}

