/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.Parameter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResetClusterParameterGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String parameterGroupName;
    private Boolean resetAllParameters;
    private SdkInternalList<Parameter> parameters;

    public void setParameterGroupName(String parameterGroupName) {
        this.parameterGroupName = parameterGroupName;
    }

    public String getParameterGroupName() {
        return this.parameterGroupName;
    }

    public ResetClusterParameterGroupRequest withParameterGroupName(String parameterGroupName) {
        this.setParameterGroupName(parameterGroupName);
        return this;
    }

    public void setResetAllParameters(Boolean resetAllParameters) {
        this.resetAllParameters = resetAllParameters;
    }

    public Boolean getResetAllParameters() {
        return this.resetAllParameters;
    }

    public ResetClusterParameterGroupRequest withResetAllParameters(Boolean resetAllParameters) {
        this.setResetAllParameters(resetAllParameters);
        return this;
    }

    public Boolean isResetAllParameters() {
        return this.resetAllParameters;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new SdkInternalList();
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new SdkInternalList(parameters);
    }

    public ResetClusterParameterGroupRequest withParameters(Parameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters((Collection<Parameter>)new SdkInternalList(parameters.length));
        }
        for (Parameter ele : parameters) {
            this.parameters.add((Object)ele);
        }
        return this;
    }

    public ResetClusterParameterGroupRequest withParameters(Collection<Parameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getParameterGroupName() != null) {
            sb.append("ParameterGroupName: " + this.getParameterGroupName() + ",");
        }
        if (this.getResetAllParameters() != null) {
            sb.append("ResetAllParameters: " + this.getResetAllParameters() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetClusterParameterGroupRequest)) {
            return false;
        }
        ResetClusterParameterGroupRequest other = (ResetClusterParameterGroupRequest)obj;
        if (other.getParameterGroupName() == null ^ this.getParameterGroupName() == null) {
            return false;
        }
        if (other.getParameterGroupName() != null && !other.getParameterGroupName().equals(this.getParameterGroupName())) {
            return false;
        }
        if (other.getResetAllParameters() == null ^ this.getResetAllParameters() == null) {
            return false;
        }
        if (other.getResetAllParameters() != null && !other.getResetAllParameters().equals(this.getResetAllParameters())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getParameterGroupName() == null ? 0 : this.getParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getResetAllParameters() == null ? 0 : this.getResetAllParameters().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public ResetClusterParameterGroupRequest clone() {
        return (ResetClusterParameterGroupRequest)super.clone();
    }
}

