/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.DeleteClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteClusterRequestMarshaller
implements Marshaller<Request<DeleteClusterRequest>, DeleteClusterRequest> {
    public Request<DeleteClusterRequest> marshall(DeleteClusterRequest deleteClusterRequest) {
        if (deleteClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteClusterRequest, "AmazonRedshift");
        request.addParameter("Action", "DeleteCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteClusterRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)deleteClusterRequest.getClusterIdentifier()));
        }
        if (deleteClusterRequest.getSkipFinalClusterSnapshot() != null) {
            request.addParameter("SkipFinalClusterSnapshot", StringUtils.fromBoolean((Boolean)deleteClusterRequest.getSkipFinalClusterSnapshot()));
        }
        if (deleteClusterRequest.getFinalClusterSnapshotIdentifier() != null) {
            request.addParameter("FinalClusterSnapshotIdentifier", StringUtils.fromString((String)deleteClusterRequest.getFinalClusterSnapshotIdentifier()));
        }
        return request;
    }
}

