/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.CreateTagsRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateTagsRequestMarshaller
implements Marshaller<Request<CreateTagsRequest>, CreateTagsRequest> {
    public Request<CreateTagsRequest> marshall(CreateTagsRequest createTagsRequest) {
        if (createTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTagsRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateTags");
        request.addParameter("Version", "2012-12-01");
        if (createTagsRequest.getResourceName() != null) {
            request.addParameter("ResourceName", StringUtils.fromString((String)createTagsRequest.getResourceName()));
        }
        List<Tag> tagsList = createTagsRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

