/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ModifyDBProxyEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBProxyEndpointRequestMarshaller
implements Marshaller<Request<ModifyDBProxyEndpointRequest>, ModifyDBProxyEndpointRequest> {
    public Request<ModifyDBProxyEndpointRequest> marshall(ModifyDBProxyEndpointRequest modifyDBProxyEndpointRequest) {
        if (modifyDBProxyEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBProxyEndpointRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBProxyEndpoint");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBProxyEndpointRequest.getDBProxyEndpointName() != null) {
            request.addParameter("DBProxyEndpointName", StringUtils.fromString((String)modifyDBProxyEndpointRequest.getDBProxyEndpointName()));
        }
        if (modifyDBProxyEndpointRequest.getNewDBProxyEndpointName() != null) {
            request.addParameter("NewDBProxyEndpointName", StringUtils.fromString((String)modifyDBProxyEndpointRequest.getNewDBProxyEndpointName()));
        }
        if (!modifyDBProxyEndpointRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)modifyDBProxyEndpointRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)modifyDBProxyEndpointRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.member." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        return request;
    }
}

