/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rds.model.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import com.amazonaws.services.rds.model.*;
import com.amazonaws.transform.Unmarshaller;

import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ScalingConfiguration StAX Unmarshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ScalingConfigurationStaxUnmarshaller implements Unmarshaller<ScalingConfiguration, StaxUnmarshallerContext> {

    public ScalingConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScalingConfiguration scalingConfiguration = new ScalingConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return scalingConfiguration;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("MinCapacity", targetDepth)) {
                    scalingConfiguration.setMinCapacity(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxCapacity", targetDepth)) {
                    scalingConfiguration.setMaxCapacity(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AutoPause", targetDepth)) {
                    scalingConfiguration.setAutoPause(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SecondsUntilAutoPause", targetDepth)) {
                    scalingConfiguration.setSecondsUntilAutoPause(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TimeoutAction", targetDepth)) {
                    scalingConfiguration.setTimeoutAction(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SecondsBeforeTimeout", targetDepth)) {
                    scalingConfiguration.setSecondsBeforeTimeout(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return scalingConfiguration;
                }
            }
        }
    }

    private static ScalingConfigurationStaxUnmarshaller instance;

    public static ScalingConfigurationStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new ScalingConfigurationStaxUnmarshaller();
        return instance;
    }
}
