/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rds.model.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import com.amazonaws.services.rds.model.*;
import com.amazonaws.transform.Unmarshaller;

import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GlobalClusterMember StAX Unmarshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GlobalClusterMemberStaxUnmarshaller implements Unmarshaller<GlobalClusterMember, StaxUnmarshallerContext> {

    public GlobalClusterMember unmarshall(StaxUnmarshallerContext context) throws Exception {
        GlobalClusterMember globalClusterMember = new GlobalClusterMember();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 3;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return globalClusterMember;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("DBClusterArn", targetDepth)) {
                    globalClusterMember.setDBClusterArn(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Readers", targetDepth)) {
                    globalClusterMember.withReaders(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("Readers/member", targetDepth)) {
                    globalClusterMember.withReaders(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsWriter", targetDepth)) {
                    globalClusterMember.setIsWriter(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("GlobalWriteForwardingStatus", targetDepth)) {
                    globalClusterMember.setGlobalWriteForwardingStatus(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SynchronizationStatus", targetDepth)) {
                    globalClusterMember.setSynchronizationStatus(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return globalClusterMember;
                }
            }
        }
    }

    private static GlobalClusterMemberStaxUnmarshaller instance;

    public static GlobalClusterMemberStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new GlobalClusterMemberStaxUnmarshaller();
        return instance;
    }
}
