/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.SourceRegion;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class SourceRegionStaxUnmarshaller
implements Unmarshaller<SourceRegion, StaxUnmarshallerContext> {
    private static SourceRegionStaxUnmarshaller instance;

    public SourceRegion unmarshall(StaxUnmarshallerContext context) throws Exception {
        SourceRegion sourceRegion = new SourceRegion();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return sourceRegion;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("RegionName", targetDepth)) {
                    sourceRegion.setRegionName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    sourceRegion.setEndpoint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    sourceRegion.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SupportsDBInstanceAutomatedBackupsReplication", targetDepth)) continue;
                sourceRegion.setSupportsDBInstanceAutomatedBackupsReplication(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return sourceRegion;
    }

    public static SourceRegionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SourceRegionStaxUnmarshaller();
        }
        return instance;
    }
}

