/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeBlueGreenDeploymentsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeBlueGreenDeploymentsRequestMarshaller
implements Marshaller<Request<DescribeBlueGreenDeploymentsRequest>, DescribeBlueGreenDeploymentsRequest> {
    public Request<DescribeBlueGreenDeploymentsRequest> marshall(DescribeBlueGreenDeploymentsRequest describeBlueGreenDeploymentsRequest) {
        if (describeBlueGreenDeploymentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeBlueGreenDeploymentsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeBlueGreenDeployments");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeBlueGreenDeploymentsRequest.getBlueGreenDeploymentIdentifier() != null) {
            request.addParameter("BlueGreenDeploymentIdentifier", StringUtils.fromString((String)describeBlueGreenDeploymentsRequest.getBlueGreenDeploymentIdentifier()));
        }
        if (!describeBlueGreenDeploymentsRequest.getFilters().isEmpty() || !((SdkInternalList)describeBlueGreenDeploymentsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeBlueGreenDeploymentsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeBlueGreenDeploymentsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeBlueGreenDeploymentsRequest.getMarker()));
        }
        if (describeBlueGreenDeploymentsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeBlueGreenDeploymentsRequest.getMaxRecords()));
        }
        return request;
    }
}

