/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.RestoreDBClusterToPointInTimeRequest;
import com.amazonaws.services.rds.model.ScalingConfiguration;
import com.amazonaws.services.rds.model.ServerlessV2ScalingConfiguration;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class RestoreDBClusterToPointInTimeRequestMarshaller
implements Marshaller<Request<RestoreDBClusterToPointInTimeRequest>, RestoreDBClusterToPointInTimeRequest> {
    public Request<RestoreDBClusterToPointInTimeRequest> marshall(RestoreDBClusterToPointInTimeRequest restoreDBClusterToPointInTimeRequest) {
        ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
        ScalingConfiguration scalingConfiguration;
        if (restoreDBClusterToPointInTimeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBClusterToPointInTimeRequest, "AmazonRDS");
        request.addParameter("Action", "RestoreDBClusterToPointInTime");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBClusterToPointInTimeRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getDBClusterIdentifier()));
        }
        if (restoreDBClusterToPointInTimeRequest.getRestoreType() != null) {
            request.addParameter("RestoreType", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getRestoreType()));
        }
        if (restoreDBClusterToPointInTimeRequest.getSourceDBClusterIdentifier() != null) {
            request.addParameter("SourceDBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getSourceDBClusterIdentifier()));
        }
        if (restoreDBClusterToPointInTimeRequest.getRestoreToTime() != null) {
            request.addParameter("RestoreToTime", StringUtils.fromDate((Date)restoreDBClusterToPointInTimeRequest.getRestoreToTime()));
        }
        if (restoreDBClusterToPointInTimeRequest.getUseLatestRestorableTime() != null) {
            request.addParameter("UseLatestRestorableTime", StringUtils.fromBoolean((Boolean)restoreDBClusterToPointInTimeRequest.getUseLatestRestorableTime()));
        }
        if (restoreDBClusterToPointInTimeRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterToPointInTimeRequest.getPort()));
        }
        if (restoreDBClusterToPointInTimeRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getDBSubnetGroupName()));
        }
        if (restoreDBClusterToPointInTimeRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getOptionGroupName()));
        }
        if (!restoreDBClusterToPointInTimeRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)restoreDBClusterToPointInTimeRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)restoreDBClusterToPointInTimeRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (!restoreDBClusterToPointInTimeRequest.getTags().isEmpty() || !((SdkInternalList)restoreDBClusterToPointInTimeRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)restoreDBClusterToPointInTimeRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (restoreDBClusterToPointInTimeRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getKmsKeyId()));
        }
        if (restoreDBClusterToPointInTimeRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBClusterToPointInTimeRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (restoreDBClusterToPointInTimeRequest.getBacktrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringUtils.fromLong((Long)restoreDBClusterToPointInTimeRequest.getBacktrackWindow()));
        }
        if (!restoreDBClusterToPointInTimeRequest.getEnableCloudwatchLogsExports().isEmpty() || !((SdkInternalList)restoreDBClusterToPointInTimeRequest.getEnableCloudwatchLogsExports()).isAutoConstruct()) {
            SdkInternalList enableCloudwatchLogsExportsList = (SdkInternalList)restoreDBClusterToPointInTimeRequest.getEnableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (restoreDBClusterToPointInTimeRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getDBClusterParameterGroupName()));
        }
        if (restoreDBClusterToPointInTimeRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)restoreDBClusterToPointInTimeRequest.getDeletionProtection()));
        }
        if (restoreDBClusterToPointInTimeRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)restoreDBClusterToPointInTimeRequest.getCopyTagsToSnapshot()));
        }
        if (restoreDBClusterToPointInTimeRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getDomain()));
        }
        if (restoreDBClusterToPointInTimeRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getDomainIAMRoleName()));
        }
        if ((scalingConfiguration = restoreDBClusterToPointInTimeRequest.getScalingConfiguration()) != null) {
            if (scalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ScalingConfiguration.MinCapacity", StringUtils.fromInteger((Integer)scalingConfiguration.getMinCapacity()));
            }
            if (scalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ScalingConfiguration.MaxCapacity", StringUtils.fromInteger((Integer)scalingConfiguration.getMaxCapacity()));
            }
            if (scalingConfiguration.getAutoPause() != null) {
                request.addParameter("ScalingConfiguration.AutoPause", StringUtils.fromBoolean((Boolean)scalingConfiguration.getAutoPause()));
            }
            if (scalingConfiguration.getSecondsUntilAutoPause() != null) {
                request.addParameter("ScalingConfiguration.SecondsUntilAutoPause", StringUtils.fromInteger((Integer)scalingConfiguration.getSecondsUntilAutoPause()));
            }
            if (scalingConfiguration.getTimeoutAction() != null) {
                request.addParameter("ScalingConfiguration.TimeoutAction", StringUtils.fromString((String)scalingConfiguration.getTimeoutAction()));
            }
            if (scalingConfiguration.getSecondsBeforeTimeout() != null) {
                request.addParameter("ScalingConfiguration.SecondsBeforeTimeout", StringUtils.fromInteger((Integer)scalingConfiguration.getSecondsBeforeTimeout()));
            }
        }
        if (restoreDBClusterToPointInTimeRequest.getEngineMode() != null) {
            request.addParameter("EngineMode", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getEngineMode()));
        }
        if (restoreDBClusterToPointInTimeRequest.getDBClusterInstanceClass() != null) {
            request.addParameter("DBClusterInstanceClass", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getDBClusterInstanceClass()));
        }
        if (restoreDBClusterToPointInTimeRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getStorageType()));
        }
        if (restoreDBClusterToPointInTimeRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreDBClusterToPointInTimeRequest.getPubliclyAccessible()));
        }
        if (restoreDBClusterToPointInTimeRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)restoreDBClusterToPointInTimeRequest.getIops()));
        }
        if ((serverlessV2ScalingConfiguration = restoreDBClusterToPointInTimeRequest.getServerlessV2ScalingConfiguration()) != null) {
            if (serverlessV2ScalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ServerlessV2ScalingConfiguration.MinCapacity", StringUtils.fromDouble((Double)serverlessV2ScalingConfiguration.getMinCapacity()));
            }
            if (serverlessV2ScalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ServerlessV2ScalingConfiguration.MaxCapacity", StringUtils.fromDouble((Double)serverlessV2ScalingConfiguration.getMaxCapacity()));
            }
        }
        if (restoreDBClusterToPointInTimeRequest.getNetworkType() != null) {
            request.addParameter("NetworkType", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.getNetworkType()));
        }
        return request;
    }
}

