/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBProxyTargetsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBProxyTargetsRequestMarshaller
implements Marshaller<Request<DescribeDBProxyTargetsRequest>, DescribeDBProxyTargetsRequest> {
    public Request<DescribeDBProxyTargetsRequest> marshall(DescribeDBProxyTargetsRequest describeDBProxyTargetsRequest) {
        if (describeDBProxyTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBProxyTargetsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBProxyTargets");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBProxyTargetsRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString((String)describeDBProxyTargetsRequest.getDBProxyName()));
        }
        if (describeDBProxyTargetsRequest.getTargetGroupName() != null) {
            request.addParameter("TargetGroupName", StringUtils.fromString((String)describeDBProxyTargetsRequest.getTargetGroupName()));
        }
        if (!describeDBProxyTargetsRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBProxyTargetsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBProxyTargetsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBProxyTargetsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBProxyTargetsRequest.getMarker()));
        }
        if (describeDBProxyTargetsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBProxyTargetsRequest.getMaxRecords()));
        }
        return request;
    }
}

