/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ram.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.ram.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AssociatedPermission JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AssociatedPermissionJsonUnmarshaller implements Unmarshaller<AssociatedPermission, JsonUnmarshallerContext> {

    public AssociatedPermission unmarshall(JsonUnmarshallerContext context) throws Exception {
        AssociatedPermission associatedPermission = new AssociatedPermission();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    associatedPermission.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("permissionVersion", targetDepth)) {
                    context.nextToken();
                    associatedPermission.setPermissionVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("defaultVersion", targetDepth)) {
                    context.nextToken();
                    associatedPermission.setDefaultVersion(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    associatedPermission.setResourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    associatedPermission.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("featureSet", targetDepth)) {
                    context.nextToken();
                    associatedPermission.setFeatureSet(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastUpdatedTime", targetDepth)) {
                    context.nextToken();
                    associatedPermission.setLastUpdatedTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("resourceShareArn", targetDepth)) {
                    context.nextToken();
                    associatedPermission.setResourceShareArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return associatedPermission;
    }

    private static AssociatedPermissionJsonUnmarshaller instance;

    public static AssociatedPermissionJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new AssociatedPermissionJsonUnmarshaller();
        return instance;
    }
}
