/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.Ingestion;
import java.util.Date;

@SdkInternalApi
public class IngestionMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> INGESTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IngestionId").build();
    private static final MarshallingInfo<String> INGESTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IngestionStatus").build();
    private static final MarshallingInfo<StructuredPojo> ERRORINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorInfo").build();
    private static final MarshallingInfo<StructuredPojo> ROWINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowInfo").build();
    private static final MarshallingInfo<StructuredPojo> QUEUEINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueueInfo").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> INGESTIONTIMEINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IngestionTimeInSeconds").build();
    private static final MarshallingInfo<Long> INGESTIONSIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IngestionSizeInBytes").build();
    private static final MarshallingInfo<String> REQUESTSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestSource").build();
    private static final MarshallingInfo<String> REQUESTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestType").build();
    private static final IngestionMarshaller instance = new IngestionMarshaller();

    public static IngestionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Ingestion ingestion, ProtocolMarshaller protocolMarshaller) {
        if (ingestion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ingestion.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getIngestionId(), INGESTIONID_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getIngestionStatus(), INGESTIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getErrorInfo(), ERRORINFO_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getRowInfo(), ROWINFO_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getQueueInfo(), QUEUEINFO_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getIngestionTimeInSeconds(), INGESTIONTIMEINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getIngestionSizeInBytes(), INGESTIONSIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getRequestSource(), REQUESTSOURCE_BINDING);
            protocolMarshaller.marshall((Object)ingestion.getRequestType(), REQUESTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

