/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.FontConfiguration;

@SdkInternalApi
public class FontConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> FONTSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FontSize").build();
    private static final MarshallingInfo<String> FONTDECORATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FontDecoration").build();
    private static final MarshallingInfo<String> FONTCOLOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FontColor").build();
    private static final MarshallingInfo<StructuredPojo> FONTWEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FontWeight").build();
    private static final MarshallingInfo<String> FONTSTYLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FontStyle").build();
    private static final FontConfigurationMarshaller instance = new FontConfigurationMarshaller();

    public static FontConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(FontConfiguration fontConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (fontConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fontConfiguration.getFontSize(), FONTSIZE_BINDING);
            protocolMarshaller.marshall((Object)fontConfiguration.getFontDecoration(), FONTDECORATION_BINDING);
            protocolMarshaller.marshall((Object)fontConfiguration.getFontColor(), FONTCOLOR_BINDING);
            protocolMarshaller.marshall((Object)fontConfiguration.getFontWeight(), FONTWEIGHT_BINDING);
            protocolMarshaller.marshall((Object)fontConfiguration.getFontStyle(), FONTSTYLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

