/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.DataColor;

@SdkInternalApi
public class DataColorMarshaller {
    private static final MarshallingInfo<String> COLOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Color").build();
    private static final MarshallingInfo<Double> DATAVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataValue").build();
    private static final DataColorMarshaller instance = new DataColorMarshaller();

    public static DataColorMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataColor dataColor, ProtocolMarshaller protocolMarshaller) {
        if (dataColor == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataColor.getColor(), COLOR_BINDING);
            protocolMarshaller.marshall((Object)dataColor.getDataValue(), DATAVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

