/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.services.quicksight.model.Typography;
import com.amazonaws.services.quicksight.model.transform.FontJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class TypographyJsonUnmarshaller
implements Unmarshaller<Typography, JsonUnmarshallerContext> {
    private static TypographyJsonUnmarshaller instance;

    public Typography unmarshall(JsonUnmarshallerContext context) throws Exception {
        Typography typography = new Typography();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("FontFamilies", targetDepth)) {
                    context.nextToken();
                    typography.setFontFamilies(new ListUnmarshaller((Unmarshaller)FontJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return typography;
    }

    public static TypographyJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TypographyJsonUnmarshaller();
        }
        return instance;
    }
}

