/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DatasetMetadata;
import java.util.List;

@SdkInternalApi
public class DatasetMetadataMarshaller {
    private static final MarshallingInfo<String> DATASETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetArn").build();
    private static final MarshallingInfo<String> DATASETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetName").build();
    private static final MarshallingInfo<String> DATASETDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetDescription").build();
    private static final MarshallingInfo<StructuredPojo> DATAAGGREGATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataAggregation").build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").build();
    private static final MarshallingInfo<List> COLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Columns").build();
    private static final MarshallingInfo<List> CALCULATEDFIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CalculatedFields").build();
    private static final MarshallingInfo<List> NAMEDENTITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamedEntities").build();
    private static final DatasetMetadataMarshaller instance = new DatasetMetadataMarshaller();

    public static DatasetMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(DatasetMetadata datasetMetadata, ProtocolMarshaller protocolMarshaller) {
        if (datasetMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)datasetMetadata.getDatasetArn(), DATASETARN_BINDING);
            protocolMarshaller.marshall((Object)datasetMetadata.getDatasetName(), DATASETNAME_BINDING);
            protocolMarshaller.marshall((Object)datasetMetadata.getDatasetDescription(), DATASETDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)datasetMetadata.getDataAggregation(), DATAAGGREGATION_BINDING);
            protocolMarshaller.marshall(datasetMetadata.getFilters(), FILTERS_BINDING);
            protocolMarshaller.marshall(datasetMetadata.getColumns(), COLUMNS_BINDING);
            protocolMarshaller.marshall(datasetMetadata.getCalculatedFields(), CALCULATEDFIELDS_BINDING);
            protocolMarshaller.marshall(datasetMetadata.getNamedEntities(), NAMEDENTITIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

