/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.LogicalTableSource;
import com.amazonaws.services.quicksight.model.TransformOperation;
import com.amazonaws.services.quicksight.model.transform.LogicalTableMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LogicalTable
implements Serializable,
Cloneable,
StructuredPojo {
    private String alias;
    private List<TransformOperation> dataTransforms;
    private LogicalTableSource source;

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public LogicalTable withAlias(String alias) {
        this.setAlias(alias);
        return this;
    }

    public List<TransformOperation> getDataTransforms() {
        return this.dataTransforms;
    }

    public void setDataTransforms(Collection<TransformOperation> dataTransforms) {
        if (dataTransforms == null) {
            this.dataTransforms = null;
            return;
        }
        this.dataTransforms = new ArrayList<TransformOperation>(dataTransforms);
    }

    public LogicalTable withDataTransforms(TransformOperation ... dataTransforms) {
        if (this.dataTransforms == null) {
            this.setDataTransforms(new ArrayList<TransformOperation>(dataTransforms.length));
        }
        for (TransformOperation ele : dataTransforms) {
            this.dataTransforms.add(ele);
        }
        return this;
    }

    public LogicalTable withDataTransforms(Collection<TransformOperation> dataTransforms) {
        this.setDataTransforms(dataTransforms);
        return this;
    }

    public void setSource(LogicalTableSource source) {
        this.source = source;
    }

    public LogicalTableSource getSource() {
        return this.source;
    }

    public LogicalTable withSource(LogicalTableSource source) {
        this.setSource(source);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlias() != null) {
            sb.append("Alias: ").append(this.getAlias()).append(",");
        }
        if (this.getDataTransforms() != null) {
            sb.append("DataTransforms: ").append(this.getDataTransforms()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalTable)) {
            return false;
        }
        LogicalTable other = (LogicalTable)obj;
        if (other.getAlias() == null ^ this.getAlias() == null) {
            return false;
        }
        if (other.getAlias() != null && !other.getAlias().equals(this.getAlias())) {
            return false;
        }
        if (other.getDataTransforms() == null ^ this.getDataTransforms() == null) {
            return false;
        }
        if (other.getDataTransforms() != null && !other.getDataTransforms().equals(this.getDataTransforms())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        return other.getSource() == null || other.getSource().equals(this.getSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlias() == null ? 0 : this.getAlias().hashCode());
        hashCode = 31 * hashCode + (this.getDataTransforms() == null ? 0 : this.getDataTransforms().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        return hashCode;
    }

    public LogicalTable clone() {
        try {
            return (LogicalTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogicalTableMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

