/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.FreeFormLayoutCanvasSizeOptions;
import com.amazonaws.services.quicksight.model.FreeFormLayoutElement;
import com.amazonaws.services.quicksight.model.transform.FreeFormLayoutConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FreeFormLayoutConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FreeFormLayoutElement> elements;
    private FreeFormLayoutCanvasSizeOptions canvasSizeOptions;

    public List<FreeFormLayoutElement> getElements() {
        return this.elements;
    }

    public void setElements(Collection<FreeFormLayoutElement> elements) {
        if (elements == null) {
            this.elements = null;
            return;
        }
        this.elements = new ArrayList<FreeFormLayoutElement>(elements);
    }

    public FreeFormLayoutConfiguration withElements(FreeFormLayoutElement ... elements) {
        if (this.elements == null) {
            this.setElements(new ArrayList<FreeFormLayoutElement>(elements.length));
        }
        for (FreeFormLayoutElement ele : elements) {
            this.elements.add(ele);
        }
        return this;
    }

    public FreeFormLayoutConfiguration withElements(Collection<FreeFormLayoutElement> elements) {
        this.setElements(elements);
        return this;
    }

    public void setCanvasSizeOptions(FreeFormLayoutCanvasSizeOptions canvasSizeOptions) {
        this.canvasSizeOptions = canvasSizeOptions;
    }

    public FreeFormLayoutCanvasSizeOptions getCanvasSizeOptions() {
        return this.canvasSizeOptions;
    }

    public FreeFormLayoutConfiguration withCanvasSizeOptions(FreeFormLayoutCanvasSizeOptions canvasSizeOptions) {
        this.setCanvasSizeOptions(canvasSizeOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getElements() != null) {
            sb.append("Elements: ").append(this.getElements()).append(",");
        }
        if (this.getCanvasSizeOptions() != null) {
            sb.append("CanvasSizeOptions: ").append(this.getCanvasSizeOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeFormLayoutConfiguration)) {
            return false;
        }
        FreeFormLayoutConfiguration other = (FreeFormLayoutConfiguration)obj;
        if (other.getElements() == null ^ this.getElements() == null) {
            return false;
        }
        if (other.getElements() != null && !other.getElements().equals(this.getElements())) {
            return false;
        }
        if (other.getCanvasSizeOptions() == null ^ this.getCanvasSizeOptions() == null) {
            return false;
        }
        return other.getCanvasSizeOptions() == null || other.getCanvasSizeOptions().equals(this.getCanvasSizeOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getElements() == null ? 0 : this.getElements().hashCode());
        hashCode = 31 * hashCode + (this.getCanvasSizeOptions() == null ? 0 : this.getCanvasSizeOptions().hashCode());
        return hashCode;
    }

    public FreeFormLayoutConfiguration clone() {
        try {
            return (FreeFormLayoutConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FreeFormLayoutConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

