/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldb.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.qldb.model.KinesisConfiguration;

@SdkInternalApi
public class KinesisConfigurationMarshaller {
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamArn").build();
    private static final MarshallingInfo<Boolean> AGGREGATIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AggregationEnabled").build();
    private static final KinesisConfigurationMarshaller instance = new KinesisConfigurationMarshaller();

    public static KinesisConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(KinesisConfiguration kinesisConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (kinesisConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kinesisConfiguration.getStreamArn(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisConfiguration.getAggregationEnabled(), AGGREGATIONENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

