/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qapps.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qapps.model.Card;
import com.amazonaws.services.qapps.model.transform.AppDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AppDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String appDefinitionVersion;
    private List<Card> cards;
    private Boolean canEdit;

    public void setAppDefinitionVersion(String appDefinitionVersion) {
        this.appDefinitionVersion = appDefinitionVersion;
    }

    public String getAppDefinitionVersion() {
        return this.appDefinitionVersion;
    }

    public AppDefinition withAppDefinitionVersion(String appDefinitionVersion) {
        this.setAppDefinitionVersion(appDefinitionVersion);
        return this;
    }

    public List<Card> getCards() {
        return this.cards;
    }

    public void setCards(Collection<Card> cards) {
        if (cards == null) {
            this.cards = null;
            return;
        }
        this.cards = new ArrayList<Card>(cards);
    }

    public AppDefinition withCards(Card ... cards) {
        if (this.cards == null) {
            this.setCards(new ArrayList<Card>(cards.length));
        }
        for (Card ele : cards) {
            this.cards.add(ele);
        }
        return this;
    }

    public AppDefinition withCards(Collection<Card> cards) {
        this.setCards(cards);
        return this;
    }

    public void setCanEdit(Boolean canEdit) {
        this.canEdit = canEdit;
    }

    public Boolean getCanEdit() {
        return this.canEdit;
    }

    public AppDefinition withCanEdit(Boolean canEdit) {
        this.setCanEdit(canEdit);
        return this;
    }

    public Boolean isCanEdit() {
        return this.canEdit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppDefinitionVersion() != null) {
            sb.append("AppDefinitionVersion: ").append(this.getAppDefinitionVersion()).append(",");
        }
        if (this.getCards() != null) {
            sb.append("Cards: ").append(this.getCards()).append(",");
        }
        if (this.getCanEdit() != null) {
            sb.append("CanEdit: ").append(this.getCanEdit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppDefinition)) {
            return false;
        }
        AppDefinition other = (AppDefinition)obj;
        if (other.getAppDefinitionVersion() == null ^ this.getAppDefinitionVersion() == null) {
            return false;
        }
        if (other.getAppDefinitionVersion() != null && !other.getAppDefinitionVersion().equals(this.getAppDefinitionVersion())) {
            return false;
        }
        if (other.getCards() == null ^ this.getCards() == null) {
            return false;
        }
        if (other.getCards() != null && !other.getCards().equals(this.getCards())) {
            return false;
        }
        if (other.getCanEdit() == null ^ this.getCanEdit() == null) {
            return false;
        }
        return other.getCanEdit() == null || other.getCanEdit().equals(this.getCanEdit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppDefinitionVersion() == null ? 0 : this.getAppDefinitionVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCards() == null ? 0 : this.getCards().hashCode());
        hashCode = 31 * hashCode + (this.getCanEdit() == null ? 0 : this.getCanEdit().hashCode());
        return hashCode;
    }

    public AppDefinition clone() {
        try {
            return (AppDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

