/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qapps;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.qapps.AWSQApps;
import com.amazonaws.services.qapps.AWSQAppsClientBuilder;
import com.amazonaws.services.qapps.model.AWSQAppsException;
import com.amazonaws.services.qapps.model.AssociateLibraryItemReviewRequest;
import com.amazonaws.services.qapps.model.AssociateLibraryItemReviewResult;
import com.amazonaws.services.qapps.model.AssociateQAppWithUserRequest;
import com.amazonaws.services.qapps.model.AssociateQAppWithUserResult;
import com.amazonaws.services.qapps.model.CreateLibraryItemRequest;
import com.amazonaws.services.qapps.model.CreateLibraryItemResult;
import com.amazonaws.services.qapps.model.CreateQAppRequest;
import com.amazonaws.services.qapps.model.CreateQAppResult;
import com.amazonaws.services.qapps.model.DeleteLibraryItemRequest;
import com.amazonaws.services.qapps.model.DeleteLibraryItemResult;
import com.amazonaws.services.qapps.model.DeleteQAppRequest;
import com.amazonaws.services.qapps.model.DeleteQAppResult;
import com.amazonaws.services.qapps.model.DisassociateLibraryItemReviewRequest;
import com.amazonaws.services.qapps.model.DisassociateLibraryItemReviewResult;
import com.amazonaws.services.qapps.model.DisassociateQAppFromUserRequest;
import com.amazonaws.services.qapps.model.DisassociateQAppFromUserResult;
import com.amazonaws.services.qapps.model.GetLibraryItemRequest;
import com.amazonaws.services.qapps.model.GetLibraryItemResult;
import com.amazonaws.services.qapps.model.GetQAppRequest;
import com.amazonaws.services.qapps.model.GetQAppResult;
import com.amazonaws.services.qapps.model.GetQAppSessionRequest;
import com.amazonaws.services.qapps.model.GetQAppSessionResult;
import com.amazonaws.services.qapps.model.ImportDocumentRequest;
import com.amazonaws.services.qapps.model.ImportDocumentResult;
import com.amazonaws.services.qapps.model.ListLibraryItemsRequest;
import com.amazonaws.services.qapps.model.ListLibraryItemsResult;
import com.amazonaws.services.qapps.model.ListQAppsRequest;
import com.amazonaws.services.qapps.model.ListQAppsResult;
import com.amazonaws.services.qapps.model.ListTagsForResourceRequest;
import com.amazonaws.services.qapps.model.ListTagsForResourceResult;
import com.amazonaws.services.qapps.model.PredictQAppRequest;
import com.amazonaws.services.qapps.model.PredictQAppResult;
import com.amazonaws.services.qapps.model.StartQAppSessionRequest;
import com.amazonaws.services.qapps.model.StartQAppSessionResult;
import com.amazonaws.services.qapps.model.StopQAppSessionRequest;
import com.amazonaws.services.qapps.model.StopQAppSessionResult;
import com.amazonaws.services.qapps.model.TagResourceRequest;
import com.amazonaws.services.qapps.model.TagResourceResult;
import com.amazonaws.services.qapps.model.UntagResourceRequest;
import com.amazonaws.services.qapps.model.UntagResourceResult;
import com.amazonaws.services.qapps.model.UpdateLibraryItemRequest;
import com.amazonaws.services.qapps.model.UpdateLibraryItemResult;
import com.amazonaws.services.qapps.model.UpdateQAppRequest;
import com.amazonaws.services.qapps.model.UpdateQAppResult;
import com.amazonaws.services.qapps.model.UpdateQAppSessionRequest;
import com.amazonaws.services.qapps.model.UpdateQAppSessionResult;
import com.amazonaws.services.qapps.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.qapps.model.transform.AssociateLibraryItemReviewRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.AssociateLibraryItemReviewResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.AssociateQAppWithUserRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.AssociateQAppWithUserResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ContentTooLargeExceptionUnmarshaller;
import com.amazonaws.services.qapps.model.transform.CreateLibraryItemRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.CreateLibraryItemResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.CreateQAppRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.CreateQAppResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.DeleteLibraryItemRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.DeleteLibraryItemResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.DeleteQAppRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.DeleteQAppResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.DisassociateLibraryItemReviewRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.DisassociateLibraryItemReviewResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.DisassociateQAppFromUserRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.DisassociateQAppFromUserResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.GetLibraryItemRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.GetLibraryItemResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.GetQAppRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.GetQAppResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.GetQAppSessionRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.GetQAppSessionResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ImportDocumentRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.ImportDocumentResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ListLibraryItemsRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.ListLibraryItemsResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ListQAppsRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.ListQAppsResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.PredictQAppRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.PredictQAppResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.qapps.model.transform.StartQAppSessionRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.StartQAppSessionResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.StopQAppSessionRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.StopQAppSessionResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.qapps.model.transform.UnauthorizedExceptionUnmarshaller;
import com.amazonaws.services.qapps.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.UpdateLibraryItemRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.UpdateLibraryItemResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.UpdateQAppRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.UpdateQAppResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.UpdateQAppSessionRequestProtocolMarshaller;
import com.amazonaws.services.qapps.model.transform.UpdateQAppSessionResultJsonUnmarshaller;
import com.amazonaws.services.qapps.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSQAppsClient
extends AmazonWebServiceClient
implements AWSQApps {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSQApps.class);
    private static final String DEFAULT_SIGNING_NAME = "qapps";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ContentTooLargeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ContentTooLargeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnauthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSQAppsException.class));

    public static AWSQAppsClientBuilder builder() {
        return AWSQAppsClientBuilder.standard();
    }

    AWSQAppsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSQAppsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("data.qapps");
        this.setEndpoint("data.qapps.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/qapps/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/qapps/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateLibraryItemReviewResult associateLibraryItemReview(AssociateLibraryItemReviewRequest request) {
        request = (AssociateLibraryItemReviewRequest)this.beforeClientExecution(request);
        return this.executeAssociateLibraryItemReview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateLibraryItemReviewResult executeAssociateLibraryItemReview(AssociateLibraryItemReviewRequest associateLibraryItemReviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateLibraryItemReviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateLibraryItemReviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateLibraryItemReviewRequestProtocolMarshaller(protocolFactory).marshall((AssociateLibraryItemReviewRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateLibraryItemReviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateLibraryItemReview");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateLibraryItemReviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateLibraryItemReviewResult associateLibraryItemReviewResult = (AssociateLibraryItemReviewResult)response.getAwsResponse();
            return associateLibraryItemReviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateQAppWithUserResult associateQAppWithUser(AssociateQAppWithUserRequest request) {
        request = (AssociateQAppWithUserRequest)this.beforeClientExecution(request);
        return this.executeAssociateQAppWithUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateQAppWithUserResult executeAssociateQAppWithUser(AssociateQAppWithUserRequest associateQAppWithUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateQAppWithUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateQAppWithUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateQAppWithUserRequestProtocolMarshaller(protocolFactory).marshall((AssociateQAppWithUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateQAppWithUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateQAppWithUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateQAppWithUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateQAppWithUserResult associateQAppWithUserResult = (AssociateQAppWithUserResult)response.getAwsResponse();
            return associateQAppWithUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLibraryItemResult createLibraryItem(CreateLibraryItemRequest request) {
        request = (CreateLibraryItemRequest)this.beforeClientExecution(request);
        return this.executeCreateLibraryItem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLibraryItemResult executeCreateLibraryItem(CreateLibraryItemRequest createLibraryItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLibraryItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLibraryItemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLibraryItemRequestProtocolMarshaller(protocolFactory).marshall((CreateLibraryItemRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLibraryItemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLibraryItem");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLibraryItemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLibraryItemResult createLibraryItemResult = (CreateLibraryItemResult)response.getAwsResponse();
            return createLibraryItemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateQAppResult createQApp(CreateQAppRequest request) {
        request = (CreateQAppRequest)this.beforeClientExecution(request);
        return this.executeCreateQApp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateQAppResult executeCreateQApp(CreateQAppRequest createQAppRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createQAppRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateQAppRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateQAppRequestProtocolMarshaller(protocolFactory).marshall((CreateQAppRequest)super.beforeMarshalling((AmazonWebServiceRequest)createQAppRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateQApp");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateQAppResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateQAppResult createQAppResult = (CreateQAppResult)response.getAwsResponse();
            return createQAppResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLibraryItemResult deleteLibraryItem(DeleteLibraryItemRequest request) {
        request = (DeleteLibraryItemRequest)this.beforeClientExecution(request);
        return this.executeDeleteLibraryItem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLibraryItemResult executeDeleteLibraryItem(DeleteLibraryItemRequest deleteLibraryItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLibraryItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLibraryItemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLibraryItemRequestProtocolMarshaller(protocolFactory).marshall((DeleteLibraryItemRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLibraryItemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLibraryItem");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLibraryItemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLibraryItemResult deleteLibraryItemResult = (DeleteLibraryItemResult)response.getAwsResponse();
            return deleteLibraryItemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteQAppResult deleteQApp(DeleteQAppRequest request) {
        request = (DeleteQAppRequest)this.beforeClientExecution(request);
        return this.executeDeleteQApp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteQAppResult executeDeleteQApp(DeleteQAppRequest deleteQAppRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteQAppRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteQAppRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteQAppRequestProtocolMarshaller(protocolFactory).marshall((DeleteQAppRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteQAppRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteQApp");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteQAppResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteQAppResult deleteQAppResult = (DeleteQAppResult)response.getAwsResponse();
            return deleteQAppResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateLibraryItemReviewResult disassociateLibraryItemReview(DisassociateLibraryItemReviewRequest request) {
        request = (DisassociateLibraryItemReviewRequest)this.beforeClientExecution(request);
        return this.executeDisassociateLibraryItemReview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateLibraryItemReviewResult executeDisassociateLibraryItemReview(DisassociateLibraryItemReviewRequest disassociateLibraryItemReviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateLibraryItemReviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateLibraryItemReviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateLibraryItemReviewRequestProtocolMarshaller(protocolFactory).marshall((DisassociateLibraryItemReviewRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateLibraryItemReviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateLibraryItemReview");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateLibraryItemReviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateLibraryItemReviewResult disassociateLibraryItemReviewResult = (DisassociateLibraryItemReviewResult)response.getAwsResponse();
            return disassociateLibraryItemReviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateQAppFromUserResult disassociateQAppFromUser(DisassociateQAppFromUserRequest request) {
        request = (DisassociateQAppFromUserRequest)this.beforeClientExecution(request);
        return this.executeDisassociateQAppFromUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateQAppFromUserResult executeDisassociateQAppFromUser(DisassociateQAppFromUserRequest disassociateQAppFromUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateQAppFromUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateQAppFromUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateQAppFromUserRequestProtocolMarshaller(protocolFactory).marshall((DisassociateQAppFromUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateQAppFromUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateQAppFromUser");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateQAppFromUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateQAppFromUserResult disassociateQAppFromUserResult = (DisassociateQAppFromUserResult)response.getAwsResponse();
            return disassociateQAppFromUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLibraryItemResult getLibraryItem(GetLibraryItemRequest request) {
        request = (GetLibraryItemRequest)this.beforeClientExecution(request);
        return this.executeGetLibraryItem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLibraryItemResult executeGetLibraryItem(GetLibraryItemRequest getLibraryItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLibraryItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLibraryItemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLibraryItemRequestProtocolMarshaller(protocolFactory).marshall((GetLibraryItemRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLibraryItemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLibraryItem");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLibraryItemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLibraryItemResult getLibraryItemResult = (GetLibraryItemResult)response.getAwsResponse();
            return getLibraryItemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetQAppResult getQApp(GetQAppRequest request) {
        request = (GetQAppRequest)this.beforeClientExecution(request);
        return this.executeGetQApp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQAppResult executeGetQApp(GetQAppRequest getQAppRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQAppRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQAppRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQAppRequestProtocolMarshaller(protocolFactory).marshall((GetQAppRequest)super.beforeMarshalling((AmazonWebServiceRequest)getQAppRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetQApp");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQAppResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetQAppResult getQAppResult = (GetQAppResult)response.getAwsResponse();
            return getQAppResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetQAppSessionResult getQAppSession(GetQAppSessionRequest request) {
        request = (GetQAppSessionRequest)this.beforeClientExecution(request);
        return this.executeGetQAppSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQAppSessionResult executeGetQAppSession(GetQAppSessionRequest getQAppSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQAppSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQAppSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQAppSessionRequestProtocolMarshaller(protocolFactory).marshall((GetQAppSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getQAppSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetQAppSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQAppSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetQAppSessionResult getQAppSessionResult = (GetQAppSessionResult)response.getAwsResponse();
            return getQAppSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ImportDocumentResult importDocument(ImportDocumentRequest request) {
        request = (ImportDocumentRequest)this.beforeClientExecution(request);
        return this.executeImportDocument(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ImportDocumentResult executeImportDocument(ImportDocumentRequest importDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(importDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ImportDocumentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ImportDocumentRequestProtocolMarshaller(protocolFactory).marshall((ImportDocumentRequest)super.beforeMarshalling((AmazonWebServiceRequest)importDocumentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ImportDocument");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportDocumentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ImportDocumentResult importDocumentResult = (ImportDocumentResult)response.getAwsResponse();
            return importDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLibraryItemsResult listLibraryItems(ListLibraryItemsRequest request) {
        request = (ListLibraryItemsRequest)this.beforeClientExecution(request);
        return this.executeListLibraryItems(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLibraryItemsResult executeListLibraryItems(ListLibraryItemsRequest listLibraryItemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLibraryItemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLibraryItemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLibraryItemsRequestProtocolMarshaller(protocolFactory).marshall((ListLibraryItemsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLibraryItemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLibraryItems");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLibraryItemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLibraryItemsResult listLibraryItemsResult = (ListLibraryItemsResult)response.getAwsResponse();
            return listLibraryItemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQAppsResult listQApps(ListQAppsRequest request) {
        request = (ListQAppsRequest)this.beforeClientExecution(request);
        return this.executeListQApps(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListQAppsResult executeListQApps(ListQAppsRequest listQAppsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQAppsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListQAppsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListQAppsRequestProtocolMarshaller(protocolFactory).marshall((ListQAppsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listQAppsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListQApps");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQAppsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListQAppsResult listQAppsResult = (ListQAppsResult)response.getAwsResponse();
            return listQAppsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PredictQAppResult predictQApp(PredictQAppRequest request) {
        request = (PredictQAppRequest)this.beforeClientExecution(request);
        return this.executePredictQApp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PredictQAppResult executePredictQApp(PredictQAppRequest predictQAppRequest) {
        ExecutionContext executionContext = this.createExecutionContext(predictQAppRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PredictQAppRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PredictQAppRequestProtocolMarshaller(protocolFactory).marshall((PredictQAppRequest)super.beforeMarshalling((AmazonWebServiceRequest)predictQAppRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PredictQApp");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PredictQAppResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PredictQAppResult predictQAppResult = (PredictQAppResult)response.getAwsResponse();
            return predictQAppResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartQAppSessionResult startQAppSession(StartQAppSessionRequest request) {
        request = (StartQAppSessionRequest)this.beforeClientExecution(request);
        return this.executeStartQAppSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartQAppSessionResult executeStartQAppSession(StartQAppSessionRequest startQAppSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startQAppSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartQAppSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartQAppSessionRequestProtocolMarshaller(protocolFactory).marshall((StartQAppSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startQAppSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartQAppSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartQAppSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartQAppSessionResult startQAppSessionResult = (StartQAppSessionResult)response.getAwsResponse();
            return startQAppSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopQAppSessionResult stopQAppSession(StopQAppSessionRequest request) {
        request = (StopQAppSessionRequest)this.beforeClientExecution(request);
        return this.executeStopQAppSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopQAppSessionResult executeStopQAppSession(StopQAppSessionRequest stopQAppSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopQAppSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopQAppSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopQAppSessionRequestProtocolMarshaller(protocolFactory).marshall((StopQAppSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopQAppSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopQAppSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopQAppSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopQAppSessionResult stopQAppSessionResult = (StopQAppSessionResult)response.getAwsResponse();
            return stopQAppSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateLibraryItemResult updateLibraryItem(UpdateLibraryItemRequest request) {
        request = (UpdateLibraryItemRequest)this.beforeClientExecution(request);
        return this.executeUpdateLibraryItem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateLibraryItemResult executeUpdateLibraryItem(UpdateLibraryItemRequest updateLibraryItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateLibraryItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateLibraryItemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateLibraryItemRequestProtocolMarshaller(protocolFactory).marshall((UpdateLibraryItemRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateLibraryItemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateLibraryItem");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLibraryItemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateLibraryItemResult updateLibraryItemResult = (UpdateLibraryItemResult)response.getAwsResponse();
            return updateLibraryItemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateQAppResult updateQApp(UpdateQAppRequest request) {
        request = (UpdateQAppRequest)this.beforeClientExecution(request);
        return this.executeUpdateQApp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateQAppResult executeUpdateQApp(UpdateQAppRequest updateQAppRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateQAppRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateQAppRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateQAppRequestProtocolMarshaller(protocolFactory).marshall((UpdateQAppRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateQAppRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateQApp");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateQAppResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateQAppResult updateQAppResult = (UpdateQAppResult)response.getAwsResponse();
            return updateQAppResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateQAppSessionResult updateQAppSession(UpdateQAppSessionRequest request) {
        request = (UpdateQAppSessionRequest)this.beforeClientExecution(request);
        return this.executeUpdateQAppSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateQAppSessionResult executeUpdateQAppSession(UpdateQAppSessionRequest updateQAppSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateQAppSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateQAppSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateQAppSessionRequestProtocolMarshaller(protocolFactory).marshall((UpdateQAppSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateQAppSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"QApps");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateQAppSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateQAppSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateQAppSessionResult updateQAppSessionResult = (UpdateQAppSessionResult)response.getAwsResponse();
            return updateQAppSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

