/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.private5g;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.private5g.AWSPrivate5G;
import com.amazonaws.services.private5g.AWSPrivate5GClientBuilder;
import com.amazonaws.services.private5g.model.AWSPrivate5GException;
import com.amazonaws.services.private5g.model.AcknowledgeOrderReceiptRequest;
import com.amazonaws.services.private5g.model.AcknowledgeOrderReceiptResult;
import com.amazonaws.services.private5g.model.ActivateDeviceIdentifierRequest;
import com.amazonaws.services.private5g.model.ActivateDeviceIdentifierResult;
import com.amazonaws.services.private5g.model.ActivateNetworkSiteRequest;
import com.amazonaws.services.private5g.model.ActivateNetworkSiteResult;
import com.amazonaws.services.private5g.model.ConfigureAccessPointRequest;
import com.amazonaws.services.private5g.model.ConfigureAccessPointResult;
import com.amazonaws.services.private5g.model.CreateNetworkRequest;
import com.amazonaws.services.private5g.model.CreateNetworkResult;
import com.amazonaws.services.private5g.model.CreateNetworkSiteRequest;
import com.amazonaws.services.private5g.model.CreateNetworkSiteResult;
import com.amazonaws.services.private5g.model.DeactivateDeviceIdentifierRequest;
import com.amazonaws.services.private5g.model.DeactivateDeviceIdentifierResult;
import com.amazonaws.services.private5g.model.DeleteNetworkRequest;
import com.amazonaws.services.private5g.model.DeleteNetworkResult;
import com.amazonaws.services.private5g.model.DeleteNetworkSiteRequest;
import com.amazonaws.services.private5g.model.DeleteNetworkSiteResult;
import com.amazonaws.services.private5g.model.GetDeviceIdentifierRequest;
import com.amazonaws.services.private5g.model.GetDeviceIdentifierResult;
import com.amazonaws.services.private5g.model.GetNetworkRequest;
import com.amazonaws.services.private5g.model.GetNetworkResourceRequest;
import com.amazonaws.services.private5g.model.GetNetworkResourceResult;
import com.amazonaws.services.private5g.model.GetNetworkResult;
import com.amazonaws.services.private5g.model.GetNetworkSiteRequest;
import com.amazonaws.services.private5g.model.GetNetworkSiteResult;
import com.amazonaws.services.private5g.model.GetOrderRequest;
import com.amazonaws.services.private5g.model.GetOrderResult;
import com.amazonaws.services.private5g.model.ListDeviceIdentifiersRequest;
import com.amazonaws.services.private5g.model.ListDeviceIdentifiersResult;
import com.amazonaws.services.private5g.model.ListNetworkResourcesRequest;
import com.amazonaws.services.private5g.model.ListNetworkResourcesResult;
import com.amazonaws.services.private5g.model.ListNetworkSitesRequest;
import com.amazonaws.services.private5g.model.ListNetworkSitesResult;
import com.amazonaws.services.private5g.model.ListNetworksRequest;
import com.amazonaws.services.private5g.model.ListNetworksResult;
import com.amazonaws.services.private5g.model.ListOrdersRequest;
import com.amazonaws.services.private5g.model.ListOrdersResult;
import com.amazonaws.services.private5g.model.ListTagsForResourceRequest;
import com.amazonaws.services.private5g.model.ListTagsForResourceResult;
import com.amazonaws.services.private5g.model.PingRequest;
import com.amazonaws.services.private5g.model.PingResult;
import com.amazonaws.services.private5g.model.StartNetworkResourceUpdateRequest;
import com.amazonaws.services.private5g.model.StartNetworkResourceUpdateResult;
import com.amazonaws.services.private5g.model.TagResourceRequest;
import com.amazonaws.services.private5g.model.TagResourceResult;
import com.amazonaws.services.private5g.model.UntagResourceRequest;
import com.amazonaws.services.private5g.model.UntagResourceResult;
import com.amazonaws.services.private5g.model.UpdateNetworkSitePlanRequest;
import com.amazonaws.services.private5g.model.UpdateNetworkSitePlanResult;
import com.amazonaws.services.private5g.model.UpdateNetworkSiteRequest;
import com.amazonaws.services.private5g.model.UpdateNetworkSiteResult;
import com.amazonaws.services.private5g.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.private5g.model.transform.AcknowledgeOrderReceiptRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.AcknowledgeOrderReceiptResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ActivateDeviceIdentifierRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.ActivateDeviceIdentifierResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ActivateNetworkSiteRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.ActivateNetworkSiteResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ConfigureAccessPointRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.ConfigureAccessPointResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.CreateNetworkRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.CreateNetworkResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.CreateNetworkSiteRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.CreateNetworkSiteResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.DeactivateDeviceIdentifierRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.DeactivateDeviceIdentifierResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.DeleteNetworkRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.DeleteNetworkResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.DeleteNetworkSiteRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.DeleteNetworkSiteResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.GetDeviceIdentifierRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.GetDeviceIdentifierResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.GetNetworkRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.GetNetworkResourceRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.GetNetworkResourceResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.GetNetworkResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.GetNetworkSiteRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.GetNetworkSiteResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.GetOrderRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.GetOrderResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.private5g.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ListDeviceIdentifiersRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.ListDeviceIdentifiersResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ListNetworkResourcesRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.ListNetworkResourcesResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ListNetworkSitesRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.ListNetworkSitesResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ListNetworksRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.ListNetworksResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ListOrdersRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.ListOrdersResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.PingRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.PingResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.private5g.model.transform.StartNetworkResourceUpdateRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.StartNetworkResourceUpdateResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.private5g.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.UpdateNetworkSitePlanRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.UpdateNetworkSitePlanResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.UpdateNetworkSiteRequestProtocolMarshaller;
import com.amazonaws.services.private5g.model.transform.UpdateNetworkSiteResultJsonUnmarshaller;
import com.amazonaws.services.private5g.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSPrivate5GClient
extends AmazonWebServiceClient
implements AWSPrivate5G {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSPrivate5G.class);
    private static final String DEFAULT_SIGNING_NAME = "private-networks";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSPrivate5GException.class));

    public static AWSPrivate5GClientBuilder builder() {
        return AWSPrivate5GClientBuilder.standard();
    }

    AWSPrivate5GClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSPrivate5GClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("private-networks.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/private5g/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/private5g/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AcknowledgeOrderReceiptResult acknowledgeOrderReceipt(AcknowledgeOrderReceiptRequest request) {
        request = (AcknowledgeOrderReceiptRequest)this.beforeClientExecution(request);
        return this.executeAcknowledgeOrderReceipt(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AcknowledgeOrderReceiptResult executeAcknowledgeOrderReceipt(AcknowledgeOrderReceiptRequest acknowledgeOrderReceiptRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acknowledgeOrderReceiptRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcknowledgeOrderReceiptRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcknowledgeOrderReceiptRequestProtocolMarshaller(protocolFactory).marshall((AcknowledgeOrderReceiptRequest)super.beforeMarshalling((AmazonWebServiceRequest)acknowledgeOrderReceiptRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AcknowledgeOrderReceipt");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcknowledgeOrderReceiptResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AcknowledgeOrderReceiptResult acknowledgeOrderReceiptResult = (AcknowledgeOrderReceiptResult)response.getAwsResponse();
            return acknowledgeOrderReceiptResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ActivateDeviceIdentifierResult activateDeviceIdentifier(ActivateDeviceIdentifierRequest request) {
        request = (ActivateDeviceIdentifierRequest)this.beforeClientExecution(request);
        return this.executeActivateDeviceIdentifier(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ActivateDeviceIdentifierResult executeActivateDeviceIdentifier(ActivateDeviceIdentifierRequest activateDeviceIdentifierRequest) {
        ExecutionContext executionContext = this.createExecutionContext(activateDeviceIdentifierRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ActivateDeviceIdentifierRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ActivateDeviceIdentifierRequestProtocolMarshaller(protocolFactory).marshall((ActivateDeviceIdentifierRequest)super.beforeMarshalling((AmazonWebServiceRequest)activateDeviceIdentifierRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ActivateDeviceIdentifier");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivateDeviceIdentifierResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivateDeviceIdentifierResult activateDeviceIdentifierResult = (ActivateDeviceIdentifierResult)response.getAwsResponse();
            return activateDeviceIdentifierResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ActivateNetworkSiteResult activateNetworkSite(ActivateNetworkSiteRequest request) {
        request = (ActivateNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executeActivateNetworkSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ActivateNetworkSiteResult executeActivateNetworkSite(ActivateNetworkSiteRequest activateNetworkSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(activateNetworkSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ActivateNetworkSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ActivateNetworkSiteRequestProtocolMarshaller(protocolFactory).marshall((ActivateNetworkSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)activateNetworkSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ActivateNetworkSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivateNetworkSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivateNetworkSiteResult activateNetworkSiteResult = (ActivateNetworkSiteResult)response.getAwsResponse();
            return activateNetworkSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ConfigureAccessPointResult configureAccessPoint(ConfigureAccessPointRequest request) {
        request = (ConfigureAccessPointRequest)this.beforeClientExecution(request);
        return this.executeConfigureAccessPoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ConfigureAccessPointResult executeConfigureAccessPoint(ConfigureAccessPointRequest configureAccessPointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(configureAccessPointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfigureAccessPointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfigureAccessPointRequestProtocolMarshaller(protocolFactory).marshall((ConfigureAccessPointRequest)super.beforeMarshalling((AmazonWebServiceRequest)configureAccessPointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ConfigureAccessPoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ConfigureAccessPointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ConfigureAccessPointResult configureAccessPointResult = (ConfigureAccessPointResult)response.getAwsResponse();
            return configureAccessPointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateNetworkResult createNetwork(CreateNetworkRequest request) {
        request = (CreateNetworkRequest)this.beforeClientExecution(request);
        return this.executeCreateNetwork(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateNetworkResult executeCreateNetwork(CreateNetworkRequest createNetworkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createNetworkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateNetworkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateNetworkRequestProtocolMarshaller(protocolFactory).marshall((CreateNetworkRequest)super.beforeMarshalling((AmazonWebServiceRequest)createNetworkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateNetwork");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNetworkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateNetworkResult createNetworkResult = (CreateNetworkResult)response.getAwsResponse();
            return createNetworkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateNetworkSiteResult createNetworkSite(CreateNetworkSiteRequest request) {
        request = (CreateNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executeCreateNetworkSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateNetworkSiteResult executeCreateNetworkSite(CreateNetworkSiteRequest createNetworkSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createNetworkSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateNetworkSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateNetworkSiteRequestProtocolMarshaller(protocolFactory).marshall((CreateNetworkSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)createNetworkSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateNetworkSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNetworkSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateNetworkSiteResult createNetworkSiteResult = (CreateNetworkSiteResult)response.getAwsResponse();
            return createNetworkSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeactivateDeviceIdentifierResult deactivateDeviceIdentifier(DeactivateDeviceIdentifierRequest request) {
        request = (DeactivateDeviceIdentifierRequest)this.beforeClientExecution(request);
        return this.executeDeactivateDeviceIdentifier(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeactivateDeviceIdentifierResult executeDeactivateDeviceIdentifier(DeactivateDeviceIdentifierRequest deactivateDeviceIdentifierRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deactivateDeviceIdentifierRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeactivateDeviceIdentifierRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeactivateDeviceIdentifierRequestProtocolMarshaller(protocolFactory).marshall((DeactivateDeviceIdentifierRequest)super.beforeMarshalling((AmazonWebServiceRequest)deactivateDeviceIdentifierRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeactivateDeviceIdentifier");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeactivateDeviceIdentifierResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeactivateDeviceIdentifierResult deactivateDeviceIdentifierResult = (DeactivateDeviceIdentifierResult)response.getAwsResponse();
            return deactivateDeviceIdentifierResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNetworkResult deleteNetwork(DeleteNetworkRequest request) {
        request = (DeleteNetworkRequest)this.beforeClientExecution(request);
        return this.executeDeleteNetwork(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNetworkResult executeDeleteNetwork(DeleteNetworkRequest deleteNetworkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNetworkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNetworkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNetworkRequestProtocolMarshaller(protocolFactory).marshall((DeleteNetworkRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteNetworkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteNetwork");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNetworkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNetworkResult deleteNetworkResult = (DeleteNetworkResult)response.getAwsResponse();
            return deleteNetworkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNetworkSiteResult deleteNetworkSite(DeleteNetworkSiteRequest request) {
        request = (DeleteNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executeDeleteNetworkSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNetworkSiteResult executeDeleteNetworkSite(DeleteNetworkSiteRequest deleteNetworkSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNetworkSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNetworkSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNetworkSiteRequestProtocolMarshaller(protocolFactory).marshall((DeleteNetworkSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteNetworkSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteNetworkSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNetworkSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNetworkSiteResult deleteNetworkSiteResult = (DeleteNetworkSiteResult)response.getAwsResponse();
            return deleteNetworkSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDeviceIdentifierResult getDeviceIdentifier(GetDeviceIdentifierRequest request) {
        request = (GetDeviceIdentifierRequest)this.beforeClientExecution(request);
        return this.executeGetDeviceIdentifier(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDeviceIdentifierResult executeGetDeviceIdentifier(GetDeviceIdentifierRequest getDeviceIdentifierRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDeviceIdentifierRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDeviceIdentifierRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDeviceIdentifierRequestProtocolMarshaller(protocolFactory).marshall((GetDeviceIdentifierRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDeviceIdentifierRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDeviceIdentifier");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDeviceIdentifierResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDeviceIdentifierResult getDeviceIdentifierResult = (GetDeviceIdentifierResult)response.getAwsResponse();
            return getDeviceIdentifierResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetNetworkResult getNetwork(GetNetworkRequest request) {
        request = (GetNetworkRequest)this.beforeClientExecution(request);
        return this.executeGetNetwork(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetNetworkResult executeGetNetwork(GetNetworkRequest getNetworkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getNetworkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetNetworkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetNetworkRequestProtocolMarshaller(protocolFactory).marshall((GetNetworkRequest)super.beforeMarshalling((AmazonWebServiceRequest)getNetworkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetNetwork");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNetworkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetNetworkResult getNetworkResult = (GetNetworkResult)response.getAwsResponse();
            return getNetworkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetNetworkResourceResult getNetworkResource(GetNetworkResourceRequest request) {
        request = (GetNetworkResourceRequest)this.beforeClientExecution(request);
        return this.executeGetNetworkResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetNetworkResourceResult executeGetNetworkResource(GetNetworkResourceRequest getNetworkResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getNetworkResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetNetworkResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetNetworkResourceRequestProtocolMarshaller(protocolFactory).marshall((GetNetworkResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getNetworkResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetNetworkResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNetworkResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetNetworkResourceResult getNetworkResourceResult = (GetNetworkResourceResult)response.getAwsResponse();
            return getNetworkResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetNetworkSiteResult getNetworkSite(GetNetworkSiteRequest request) {
        request = (GetNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executeGetNetworkSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetNetworkSiteResult executeGetNetworkSite(GetNetworkSiteRequest getNetworkSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getNetworkSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetNetworkSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetNetworkSiteRequestProtocolMarshaller(protocolFactory).marshall((GetNetworkSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)getNetworkSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetNetworkSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNetworkSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetNetworkSiteResult getNetworkSiteResult = (GetNetworkSiteResult)response.getAwsResponse();
            return getNetworkSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOrderResult getOrder(GetOrderRequest request) {
        request = (GetOrderRequest)this.beforeClientExecution(request);
        return this.executeGetOrder(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOrderResult executeGetOrder(GetOrderRequest getOrderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOrderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOrderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOrderRequestProtocolMarshaller(protocolFactory).marshall((GetOrderRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOrderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOrder");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOrderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOrderResult getOrderResult = (GetOrderResult)response.getAwsResponse();
            return getOrderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDeviceIdentifiersResult listDeviceIdentifiers(ListDeviceIdentifiersRequest request) {
        request = (ListDeviceIdentifiersRequest)this.beforeClientExecution(request);
        return this.executeListDeviceIdentifiers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDeviceIdentifiersResult executeListDeviceIdentifiers(ListDeviceIdentifiersRequest listDeviceIdentifiersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDeviceIdentifiersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDeviceIdentifiersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDeviceIdentifiersRequestProtocolMarshaller(protocolFactory).marshall((ListDeviceIdentifiersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDeviceIdentifiersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDeviceIdentifiers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDeviceIdentifiersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDeviceIdentifiersResult listDeviceIdentifiersResult = (ListDeviceIdentifiersResult)response.getAwsResponse();
            return listDeviceIdentifiersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNetworkResourcesResult listNetworkResources(ListNetworkResourcesRequest request) {
        request = (ListNetworkResourcesRequest)this.beforeClientExecution(request);
        return this.executeListNetworkResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNetworkResourcesResult executeListNetworkResources(ListNetworkResourcesRequest listNetworkResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNetworkResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNetworkResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNetworkResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListNetworkResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listNetworkResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListNetworkResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNetworkResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNetworkResourcesResult listNetworkResourcesResult = (ListNetworkResourcesResult)response.getAwsResponse();
            return listNetworkResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNetworkSitesResult listNetworkSites(ListNetworkSitesRequest request) {
        request = (ListNetworkSitesRequest)this.beforeClientExecution(request);
        return this.executeListNetworkSites(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNetworkSitesResult executeListNetworkSites(ListNetworkSitesRequest listNetworkSitesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNetworkSitesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNetworkSitesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNetworkSitesRequestProtocolMarshaller(protocolFactory).marshall((ListNetworkSitesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listNetworkSitesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListNetworkSites");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNetworkSitesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNetworkSitesResult listNetworkSitesResult = (ListNetworkSitesResult)response.getAwsResponse();
            return listNetworkSitesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNetworksResult listNetworks(ListNetworksRequest request) {
        request = (ListNetworksRequest)this.beforeClientExecution(request);
        return this.executeListNetworks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNetworksResult executeListNetworks(ListNetworksRequest listNetworksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNetworksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNetworksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNetworksRequestProtocolMarshaller(protocolFactory).marshall((ListNetworksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listNetworksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListNetworks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNetworksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNetworksResult listNetworksResult = (ListNetworksResult)response.getAwsResponse();
            return listNetworksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOrdersResult listOrders(ListOrdersRequest request) {
        request = (ListOrdersRequest)this.beforeClientExecution(request);
        return this.executeListOrders(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOrdersResult executeListOrders(ListOrdersRequest listOrdersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOrdersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOrdersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOrdersRequestProtocolMarshaller(protocolFactory).marshall((ListOrdersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOrdersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOrders");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOrdersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOrdersResult listOrdersResult = (ListOrdersResult)response.getAwsResponse();
            return listOrdersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PingResult ping(PingRequest request) {
        request = (PingRequest)this.beforeClientExecution(request);
        return this.executePing(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PingResult executePing(PingRequest pingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PingRequestProtocolMarshaller(protocolFactory).marshall((PingRequest)super.beforeMarshalling((AmazonWebServiceRequest)pingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"Ping");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PingResult pingResult = (PingResult)response.getAwsResponse();
            return pingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartNetworkResourceUpdateResult startNetworkResourceUpdate(StartNetworkResourceUpdateRequest request) {
        request = (StartNetworkResourceUpdateRequest)this.beforeClientExecution(request);
        return this.executeStartNetworkResourceUpdate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartNetworkResourceUpdateResult executeStartNetworkResourceUpdate(StartNetworkResourceUpdateRequest startNetworkResourceUpdateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startNetworkResourceUpdateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartNetworkResourceUpdateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartNetworkResourceUpdateRequestProtocolMarshaller(protocolFactory).marshall((StartNetworkResourceUpdateRequest)super.beforeMarshalling((AmazonWebServiceRequest)startNetworkResourceUpdateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartNetworkResourceUpdate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartNetworkResourceUpdateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartNetworkResourceUpdateResult startNetworkResourceUpdateResult = (StartNetworkResourceUpdateResult)response.getAwsResponse();
            return startNetworkResourceUpdateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateNetworkSiteResult updateNetworkSite(UpdateNetworkSiteRequest request) {
        request = (UpdateNetworkSiteRequest)this.beforeClientExecution(request);
        return this.executeUpdateNetworkSite(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateNetworkSiteResult executeUpdateNetworkSite(UpdateNetworkSiteRequest updateNetworkSiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateNetworkSiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateNetworkSiteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateNetworkSiteRequestProtocolMarshaller(protocolFactory).marshall((UpdateNetworkSiteRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateNetworkSiteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateNetworkSite");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNetworkSiteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateNetworkSiteResult updateNetworkSiteResult = (UpdateNetworkSiteResult)response.getAwsResponse();
            return updateNetworkSiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateNetworkSitePlanResult updateNetworkSitePlan(UpdateNetworkSitePlanRequest request) {
        request = (UpdateNetworkSitePlanRequest)this.beforeClientExecution(request);
        return this.executeUpdateNetworkSitePlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateNetworkSitePlanResult executeUpdateNetworkSitePlan(UpdateNetworkSitePlanRequest updateNetworkSitePlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateNetworkSitePlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateNetworkSitePlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateNetworkSitePlanRequestProtocolMarshaller(protocolFactory).marshall((UpdateNetworkSitePlanRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateNetworkSitePlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"PrivateNetworks");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateNetworkSitePlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNetworkSitePlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateNetworkSitePlanResult updateNetworkSitePlanResult = (UpdateNetworkSitePlanResult)response.getAwsResponse();
            return updateNetworkSitePlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

