/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pricing;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.pricing.AWSPricingAsync;
import com.amazonaws.services.pricing.AWSPricingAsyncClientBuilder;
import com.amazonaws.services.pricing.AWSPricingClient;
import com.amazonaws.services.pricing.model.DescribeServicesRequest;
import com.amazonaws.services.pricing.model.DescribeServicesResult;
import com.amazonaws.services.pricing.model.GetAttributeValuesRequest;
import com.amazonaws.services.pricing.model.GetAttributeValuesResult;
import com.amazonaws.services.pricing.model.GetProductsRequest;
import com.amazonaws.services.pricing.model.GetProductsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSPricingAsyncClient
extends AWSPricingClient
implements AWSPricingAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSPricingAsyncClientBuilder asyncBuilder() {
        return AWSPricingAsyncClientBuilder.standard();
    }

    AWSPricingAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(DescribeServicesRequest request) {
        return this.describeServicesAsync(request, null);
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(DescribeServicesRequest request, final AsyncHandler<DescribeServicesRequest, DescribeServicesResult> asyncHandler) {
        final DescribeServicesRequest finalRequest = (DescribeServicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeServicesResult>(){

            @Override
            public DescribeServicesResult call() throws Exception {
                DescribeServicesResult result = null;
                try {
                    result = AWSPricingAsyncClient.this.executeDescribeServices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAttributeValuesResult> getAttributeValuesAsync(GetAttributeValuesRequest request) {
        return this.getAttributeValuesAsync(request, null);
    }

    @Override
    public Future<GetAttributeValuesResult> getAttributeValuesAsync(GetAttributeValuesRequest request, final AsyncHandler<GetAttributeValuesRequest, GetAttributeValuesResult> asyncHandler) {
        final GetAttributeValuesRequest finalRequest = (GetAttributeValuesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAttributeValuesResult>(){

            @Override
            public GetAttributeValuesResult call() throws Exception {
                GetAttributeValuesResult result = null;
                try {
                    result = AWSPricingAsyncClient.this.executeGetAttributeValues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProductsResult> getProductsAsync(GetProductsRequest request) {
        return this.getProductsAsync(request, null);
    }

    @Override
    public Future<GetProductsResult> getProductsAsync(GetProductsRequest request, final AsyncHandler<GetProductsRequest, GetProductsResult> asyncHandler) {
        final GetProductsRequest finalRequest = (GetProductsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProductsResult>(){

            @Override
            public GetProductsResult call() throws Exception {
                GetProductsResult result = null;
                try {
                    result = AWSPricingAsyncClient.this.executeGetProducts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

