/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.polly.AmazonPollyAsync;
import com.amazonaws.services.polly.AmazonPollyClient;
import com.amazonaws.services.polly.model.DeleteLexiconRequest;
import com.amazonaws.services.polly.model.DeleteLexiconResult;
import com.amazonaws.services.polly.model.DescribeVoicesRequest;
import com.amazonaws.services.polly.model.DescribeVoicesResult;
import com.amazonaws.services.polly.model.GetLexiconRequest;
import com.amazonaws.services.polly.model.GetLexiconResult;
import com.amazonaws.services.polly.model.ListLexiconsRequest;
import com.amazonaws.services.polly.model.ListLexiconsResult;
import com.amazonaws.services.polly.model.PutLexiconRequest;
import com.amazonaws.services.polly.model.PutLexiconResult;
import com.amazonaws.services.polly.model.SynthesizeSpeechRequest;
import com.amazonaws.services.polly.model.SynthesizeSpeechResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPollyAsyncClient
extends AmazonPollyClient
implements AmazonPollyAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonPollyAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonPollyAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonPollyAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteLexiconResult> deleteLexiconAsync(DeleteLexiconRequest request) {
        return this.deleteLexiconAsync(request, null);
    }

    @Override
    public Future<DeleteLexiconResult> deleteLexiconAsync(final DeleteLexiconRequest request, final AsyncHandler<DeleteLexiconRequest, DeleteLexiconResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteLexiconResult>(){

            @Override
            public DeleteLexiconResult call() throws Exception {
                DeleteLexiconResult result;
                try {
                    result = AmazonPollyAsyncClient.this.deleteLexicon(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVoicesResult> describeVoicesAsync(DescribeVoicesRequest request) {
        return this.describeVoicesAsync(request, null);
    }

    @Override
    public Future<DescribeVoicesResult> describeVoicesAsync(final DescribeVoicesRequest request, final AsyncHandler<DescribeVoicesRequest, DescribeVoicesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeVoicesResult>(){

            @Override
            public DescribeVoicesResult call() throws Exception {
                DescribeVoicesResult result;
                try {
                    result = AmazonPollyAsyncClient.this.describeVoices(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLexiconResult> getLexiconAsync(GetLexiconRequest request) {
        return this.getLexiconAsync(request, null);
    }

    @Override
    public Future<GetLexiconResult> getLexiconAsync(final GetLexiconRequest request, final AsyncHandler<GetLexiconRequest, GetLexiconResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetLexiconResult>(){

            @Override
            public GetLexiconResult call() throws Exception {
                GetLexiconResult result;
                try {
                    result = AmazonPollyAsyncClient.this.getLexicon(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLexiconsResult> listLexiconsAsync(ListLexiconsRequest request) {
        return this.listLexiconsAsync(request, null);
    }

    @Override
    public Future<ListLexiconsResult> listLexiconsAsync(final ListLexiconsRequest request, final AsyncHandler<ListLexiconsRequest, ListLexiconsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListLexiconsResult>(){

            @Override
            public ListLexiconsResult call() throws Exception {
                ListLexiconsResult result;
                try {
                    result = AmazonPollyAsyncClient.this.listLexicons(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLexiconResult> putLexiconAsync(PutLexiconRequest request) {
        return this.putLexiconAsync(request, null);
    }

    @Override
    public Future<PutLexiconResult> putLexiconAsync(final PutLexiconRequest request, final AsyncHandler<PutLexiconRequest, PutLexiconResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutLexiconResult>(){

            @Override
            public PutLexiconResult call() throws Exception {
                PutLexiconResult result;
                try {
                    result = AmazonPollyAsyncClient.this.putLexicon(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SynthesizeSpeechResult> synthesizeSpeechAsync(SynthesizeSpeechRequest request) {
        return this.synthesizeSpeechAsync(request, null);
    }

    @Override
    public Future<SynthesizeSpeechResult> synthesizeSpeechAsync(final SynthesizeSpeechRequest request, final AsyncHandler<SynthesizeSpeechRequest, SynthesizeSpeechResult> asyncHandler) {
        return this.executorService.submit(new Callable<SynthesizeSpeechResult>(){

            @Override
            public SynthesizeSpeechResult call() throws Exception {
                SynthesizeSpeechResult result;
                try {
                    result = AmazonPollyAsyncClient.this.synthesizeSpeech(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

