/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.EventDimensions;
import com.amazonaws.services.pinpoint.model.FilterType;
import com.amazonaws.services.pinpoint.model.transform.EventFilterMarshaller;
import java.io.Serializable;

public class EventFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private EventDimensions dimensions;
    private String filterType;

    public void setDimensions(EventDimensions dimensions) {
        this.dimensions = dimensions;
    }

    public EventDimensions getDimensions() {
        return this.dimensions;
    }

    public EventFilter withDimensions(EventDimensions dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public EventFilter withFilterType(String filterType) {
        this.setFilterType(filterType);
        return this;
    }

    public EventFilter withFilterType(FilterType filterType) {
        this.filterType = filterType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getFilterType() != null) {
            sb.append("FilterType: ").append(this.getFilterType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getFilterType() == null ^ this.getFilterType() == null) {
            return false;
        }
        return other.getFilterType() == null || other.getFilterType().equals(this.getFilterType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getFilterType() == null ? 0 : this.getFilterType().hashCode());
        return hashCode;
    }

    public EventFilter clone() {
        try {
            return (EventFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

