/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.RawEmail;
import com.amazonaws.services.pinpoint.model.SimpleEmail;
import com.amazonaws.services.pinpoint.model.transform.EmailMessageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmailMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private String body;
    private String feedbackForwardingAddress;
    private String fromAddress;
    private RawEmail rawEmail;
    private List<String> replyToAddresses;
    private SimpleEmail simpleEmail;
    private Map<String, List<String>> substitutions;

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public EmailMessage withBody(String body) {
        this.setBody(body);
        return this;
    }

    public void setFeedbackForwardingAddress(String feedbackForwardingAddress) {
        this.feedbackForwardingAddress = feedbackForwardingAddress;
    }

    public String getFeedbackForwardingAddress() {
        return this.feedbackForwardingAddress;
    }

    public EmailMessage withFeedbackForwardingAddress(String feedbackForwardingAddress) {
        this.setFeedbackForwardingAddress(feedbackForwardingAddress);
        return this;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public EmailMessage withFromAddress(String fromAddress) {
        this.setFromAddress(fromAddress);
        return this;
    }

    public void setRawEmail(RawEmail rawEmail) {
        this.rawEmail = rawEmail;
    }

    public RawEmail getRawEmail() {
        return this.rawEmail;
    }

    public EmailMessage withRawEmail(RawEmail rawEmail) {
        this.setRawEmail(rawEmail);
        return this;
    }

    public List<String> getReplyToAddresses() {
        return this.replyToAddresses;
    }

    public void setReplyToAddresses(Collection<String> replyToAddresses) {
        if (replyToAddresses == null) {
            this.replyToAddresses = null;
            return;
        }
        this.replyToAddresses = new ArrayList<String>(replyToAddresses);
    }

    public EmailMessage withReplyToAddresses(String ... replyToAddresses) {
        if (this.replyToAddresses == null) {
            this.setReplyToAddresses(new ArrayList<String>(replyToAddresses.length));
        }
        for (String ele : replyToAddresses) {
            this.replyToAddresses.add(ele);
        }
        return this;
    }

    public EmailMessage withReplyToAddresses(Collection<String> replyToAddresses) {
        this.setReplyToAddresses(replyToAddresses);
        return this;
    }

    public void setSimpleEmail(SimpleEmail simpleEmail) {
        this.simpleEmail = simpleEmail;
    }

    public SimpleEmail getSimpleEmail() {
        return this.simpleEmail;
    }

    public EmailMessage withSimpleEmail(SimpleEmail simpleEmail) {
        this.setSimpleEmail(simpleEmail);
        return this;
    }

    public Map<String, List<String>> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, List<String>> substitutions) {
        this.substitutions = substitutions;
    }

    public EmailMessage withSubstitutions(Map<String, List<String>> substitutions) {
        this.setSubstitutions(substitutions);
        return this;
    }

    public EmailMessage addSubstitutionsEntry(String key, List<String> value) {
        if (null == this.substitutions) {
            this.substitutions = new HashMap<String, List<String>>();
        }
        if (this.substitutions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutions.put(key, value);
        return this;
    }

    public EmailMessage clearSubstitutionsEntries() {
        this.substitutions = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getFeedbackForwardingAddress() != null) {
            sb.append("FeedbackForwardingAddress: ").append(this.getFeedbackForwardingAddress()).append(",");
        }
        if (this.getFromAddress() != null) {
            sb.append("FromAddress: ").append(this.getFromAddress()).append(",");
        }
        if (this.getRawEmail() != null) {
            sb.append("RawEmail: ").append(this.getRawEmail()).append(",");
        }
        if (this.getReplyToAddresses() != null) {
            sb.append("ReplyToAddresses: ").append(this.getReplyToAddresses()).append(",");
        }
        if (this.getSimpleEmail() != null) {
            sb.append("SimpleEmail: ").append(this.getSimpleEmail()).append(",");
        }
        if (this.getSubstitutions() != null) {
            sb.append("Substitutions: ").append(this.getSubstitutions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMessage)) {
            return false;
        }
        EmailMessage other = (EmailMessage)obj;
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getFeedbackForwardingAddress() == null ^ this.getFeedbackForwardingAddress() == null) {
            return false;
        }
        if (other.getFeedbackForwardingAddress() != null && !other.getFeedbackForwardingAddress().equals(this.getFeedbackForwardingAddress())) {
            return false;
        }
        if (other.getFromAddress() == null ^ this.getFromAddress() == null) {
            return false;
        }
        if (other.getFromAddress() != null && !other.getFromAddress().equals(this.getFromAddress())) {
            return false;
        }
        if (other.getRawEmail() == null ^ this.getRawEmail() == null) {
            return false;
        }
        if (other.getRawEmail() != null && !other.getRawEmail().equals(this.getRawEmail())) {
            return false;
        }
        if (other.getReplyToAddresses() == null ^ this.getReplyToAddresses() == null) {
            return false;
        }
        if (other.getReplyToAddresses() != null && !other.getReplyToAddresses().equals(this.getReplyToAddresses())) {
            return false;
        }
        if (other.getSimpleEmail() == null ^ this.getSimpleEmail() == null) {
            return false;
        }
        if (other.getSimpleEmail() != null && !other.getSimpleEmail().equals(this.getSimpleEmail())) {
            return false;
        }
        if (other.getSubstitutions() == null ^ this.getSubstitutions() == null) {
            return false;
        }
        return other.getSubstitutions() == null || other.getSubstitutions().equals(this.getSubstitutions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackForwardingAddress() == null ? 0 : this.getFeedbackForwardingAddress().hashCode());
        hashCode = 31 * hashCode + (this.getFromAddress() == null ? 0 : this.getFromAddress().hashCode());
        hashCode = 31 * hashCode + (this.getRawEmail() == null ? 0 : this.getRawEmail().hashCode());
        hashCode = 31 * hashCode + (this.getReplyToAddresses() == null ? 0 : this.getReplyToAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getSimpleEmail() == null ? 0 : this.getSimpleEmail().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutions() == null ? 0 : this.getSubstitutions().hashCode());
        return hashCode;
    }

    public EmailMessage clone() {
        try {
            return (EmailMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmailMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

