/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.EndpointTypesElement;
import com.amazonaws.services.pinpoint.model.JourneyCustomMessage;
import com.amazonaws.services.pinpoint.model.transform.CustomMessageActivityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomMessageActivity
implements Serializable,
Cloneable,
StructuredPojo {
    private String deliveryUri;
    private List<String> endpointTypes;
    private JourneyCustomMessage messageConfig;
    private String nextActivity;
    private String templateName;
    private String templateVersion;

    public void setDeliveryUri(String deliveryUri) {
        this.deliveryUri = deliveryUri;
    }

    public String getDeliveryUri() {
        return this.deliveryUri;
    }

    public CustomMessageActivity withDeliveryUri(String deliveryUri) {
        this.setDeliveryUri(deliveryUri);
        return this;
    }

    public List<String> getEndpointTypes() {
        return this.endpointTypes;
    }

    public void setEndpointTypes(Collection<String> endpointTypes) {
        if (endpointTypes == null) {
            this.endpointTypes = null;
            return;
        }
        this.endpointTypes = new ArrayList<String>(endpointTypes);
    }

    public CustomMessageActivity withEndpointTypes(String ... endpointTypes) {
        if (this.endpointTypes == null) {
            this.setEndpointTypes(new ArrayList<String>(endpointTypes.length));
        }
        for (String ele : endpointTypes) {
            this.endpointTypes.add(ele);
        }
        return this;
    }

    public CustomMessageActivity withEndpointTypes(Collection<String> endpointTypes) {
        this.setEndpointTypes(endpointTypes);
        return this;
    }

    public CustomMessageActivity withEndpointTypes(EndpointTypesElement ... endpointTypes) {
        ArrayList<String> endpointTypesCopy = new ArrayList<String>(endpointTypes.length);
        for (EndpointTypesElement value : endpointTypes) {
            endpointTypesCopy.add(value.toString());
        }
        if (this.getEndpointTypes() == null) {
            this.setEndpointTypes(endpointTypesCopy);
        } else {
            this.getEndpointTypes().addAll(endpointTypesCopy);
        }
        return this;
    }

    public void setMessageConfig(JourneyCustomMessage messageConfig) {
        this.messageConfig = messageConfig;
    }

    public JourneyCustomMessage getMessageConfig() {
        return this.messageConfig;
    }

    public CustomMessageActivity withMessageConfig(JourneyCustomMessage messageConfig) {
        this.setMessageConfig(messageConfig);
        return this;
    }

    public void setNextActivity(String nextActivity) {
        this.nextActivity = nextActivity;
    }

    public String getNextActivity() {
        return this.nextActivity;
    }

    public CustomMessageActivity withNextActivity(String nextActivity) {
        this.setNextActivity(nextActivity);
        return this;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public CustomMessageActivity withTemplateName(String templateName) {
        this.setTemplateName(templateName);
        return this;
    }

    public void setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
    }

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public CustomMessageActivity withTemplateVersion(String templateVersion) {
        this.setTemplateVersion(templateVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeliveryUri() != null) {
            sb.append("DeliveryUri: ").append(this.getDeliveryUri()).append(",");
        }
        if (this.getEndpointTypes() != null) {
            sb.append("EndpointTypes: ").append(this.getEndpointTypes()).append(",");
        }
        if (this.getMessageConfig() != null) {
            sb.append("MessageConfig: ").append(this.getMessageConfig()).append(",");
        }
        if (this.getNextActivity() != null) {
            sb.append("NextActivity: ").append(this.getNextActivity()).append(",");
        }
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: ").append(this.getTemplateName()).append(",");
        }
        if (this.getTemplateVersion() != null) {
            sb.append("TemplateVersion: ").append(this.getTemplateVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomMessageActivity)) {
            return false;
        }
        CustomMessageActivity other = (CustomMessageActivity)obj;
        if (other.getDeliveryUri() == null ^ this.getDeliveryUri() == null) {
            return false;
        }
        if (other.getDeliveryUri() != null && !other.getDeliveryUri().equals(this.getDeliveryUri())) {
            return false;
        }
        if (other.getEndpointTypes() == null ^ this.getEndpointTypes() == null) {
            return false;
        }
        if (other.getEndpointTypes() != null && !other.getEndpointTypes().equals(this.getEndpointTypes())) {
            return false;
        }
        if (other.getMessageConfig() == null ^ this.getMessageConfig() == null) {
            return false;
        }
        if (other.getMessageConfig() != null && !other.getMessageConfig().equals(this.getMessageConfig())) {
            return false;
        }
        if (other.getNextActivity() == null ^ this.getNextActivity() == null) {
            return false;
        }
        if (other.getNextActivity() != null && !other.getNextActivity().equals(this.getNextActivity())) {
            return false;
        }
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getTemplateVersion() == null ^ this.getTemplateVersion() == null) {
            return false;
        }
        return other.getTemplateVersion() == null || other.getTemplateVersion().equals(this.getTemplateVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeliveryUri() == null ? 0 : this.getDeliveryUri().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointTypes() == null ? 0 : this.getEndpointTypes().hashCode());
        hashCode = 31 * hashCode + (this.getMessageConfig() == null ? 0 : this.getMessageConfig().hashCode());
        hashCode = 31 * hashCode + (this.getNextActivity() == null ? 0 : this.getNextActivity().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateVersion() == null ? 0 : this.getTemplateVersion().hashCode());
        return hashCode;
    }

    public CustomMessageActivity clone() {
        try {
            return (CustomMessageActivity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomMessageActivityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

