/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.OpenHours;
import java.util.Map;

@SdkInternalApi
public class OpenHoursMarshaller {
    private static final MarshallingInfo<Map> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EMAIL").build();
    private static final MarshallingInfo<Map> SMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SMS").build();
    private static final MarshallingInfo<Map> PUSH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PUSH").build();
    private static final MarshallingInfo<Map> VOICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VOICE").build();
    private static final MarshallingInfo<Map> CUSTOM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CUSTOM").build();
    private static final OpenHoursMarshaller instance = new OpenHoursMarshaller();

    public static OpenHoursMarshaller getInstance() {
        return instance;
    }

    public void marshall(OpenHours openHours, ProtocolMarshaller protocolMarshaller) {
        if (openHours == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(openHours.getEMAIL(), EMAIL_BINDING);
            protocolMarshaller.marshall(openHours.getSMS(), SMS_BINDING);
            protocolMarshaller.marshall(openHours.getPUSH(), PUSH_BINDING);
            protocolMarshaller.marshall(openHours.getVOICE(), VOICE_BINDING);
            protocolMarshaller.marshall(openHours.getCUSTOM(), CUSTOM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

