/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.BaiduMessage;
import java.util.Map;

@SdkInternalApi
public class BaiduMessageMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<Map> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final MarshallingInfo<String> ICONREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IconReference").build();
    private static final MarshallingInfo<String> IMAGEICONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageIconUrl").build();
    private static final MarshallingInfo<String> IMAGEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageUrl").build();
    private static final MarshallingInfo<String> RAWCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RawContent").build();
    private static final MarshallingInfo<Boolean> SILENTPUSH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SilentPush").build();
    private static final MarshallingInfo<String> SMALLIMAGEICONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmallImageIconUrl").build();
    private static final MarshallingInfo<String> SOUND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sound").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<Integer> TIMETOLIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeToLive").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final BaiduMessageMarshaller instance = new BaiduMessageMarshaller();

    public static BaiduMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(BaiduMessage baiduMessage, ProtocolMarshaller protocolMarshaller) {
        if (baiduMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)baiduMessage.getAction(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getBody(), BODY_BINDING);
            protocolMarshaller.marshall(baiduMessage.getData(), DATA_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getIconReference(), ICONREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getImageIconUrl(), IMAGEICONURL_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getImageUrl(), IMAGEURL_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getRawContent(), RAWCONTENT_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getSilentPush(), SILENTPUSH_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getSmallImageIconUrl(), SMALLIMAGEICONURL_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getSound(), SOUND_BINDING);
            protocolMarshaller.marshall(baiduMessage.getSubstitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getTimeToLive(), TIMETOLIVE_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)baiduMessage.getUrl(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

