/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.pi.AWSPIAsync;
import com.amazonaws.services.pi.AWSPIAsyncClientBuilder;
import com.amazonaws.services.pi.AWSPIClient;
import com.amazonaws.services.pi.model.CreatePerformanceAnalysisReportRequest;
import com.amazonaws.services.pi.model.CreatePerformanceAnalysisReportResult;
import com.amazonaws.services.pi.model.DeletePerformanceAnalysisReportRequest;
import com.amazonaws.services.pi.model.DeletePerformanceAnalysisReportResult;
import com.amazonaws.services.pi.model.DescribeDimensionKeysRequest;
import com.amazonaws.services.pi.model.DescribeDimensionKeysResult;
import com.amazonaws.services.pi.model.GetDimensionKeyDetailsRequest;
import com.amazonaws.services.pi.model.GetDimensionKeyDetailsResult;
import com.amazonaws.services.pi.model.GetPerformanceAnalysisReportRequest;
import com.amazonaws.services.pi.model.GetPerformanceAnalysisReportResult;
import com.amazonaws.services.pi.model.GetResourceMetadataRequest;
import com.amazonaws.services.pi.model.GetResourceMetadataResult;
import com.amazonaws.services.pi.model.GetResourceMetricsRequest;
import com.amazonaws.services.pi.model.GetResourceMetricsResult;
import com.amazonaws.services.pi.model.ListAvailableResourceDimensionsRequest;
import com.amazonaws.services.pi.model.ListAvailableResourceDimensionsResult;
import com.amazonaws.services.pi.model.ListAvailableResourceMetricsRequest;
import com.amazonaws.services.pi.model.ListAvailableResourceMetricsResult;
import com.amazonaws.services.pi.model.ListPerformanceAnalysisReportsRequest;
import com.amazonaws.services.pi.model.ListPerformanceAnalysisReportsResult;
import com.amazonaws.services.pi.model.ListTagsForResourceRequest;
import com.amazonaws.services.pi.model.ListTagsForResourceResult;
import com.amazonaws.services.pi.model.TagResourceRequest;
import com.amazonaws.services.pi.model.TagResourceResult;
import com.amazonaws.services.pi.model.UntagResourceRequest;
import com.amazonaws.services.pi.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSPIAsyncClient
extends AWSPIClient
implements AWSPIAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSPIAsyncClientBuilder asyncBuilder() {
        return AWSPIAsyncClientBuilder.standard();
    }

    AWSPIAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSPIAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreatePerformanceAnalysisReportResult> createPerformanceAnalysisReportAsync(CreatePerformanceAnalysisReportRequest request) {
        return this.createPerformanceAnalysisReportAsync(request, null);
    }

    @Override
    public Future<CreatePerformanceAnalysisReportResult> createPerformanceAnalysisReportAsync(CreatePerformanceAnalysisReportRequest request, final AsyncHandler<CreatePerformanceAnalysisReportRequest, CreatePerformanceAnalysisReportResult> asyncHandler) {
        final CreatePerformanceAnalysisReportRequest finalRequest = (CreatePerformanceAnalysisReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePerformanceAnalysisReportResult>(){

            @Override
            public CreatePerformanceAnalysisReportResult call() throws Exception {
                CreatePerformanceAnalysisReportResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeCreatePerformanceAnalysisReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePerformanceAnalysisReportResult> deletePerformanceAnalysisReportAsync(DeletePerformanceAnalysisReportRequest request) {
        return this.deletePerformanceAnalysisReportAsync(request, null);
    }

    @Override
    public Future<DeletePerformanceAnalysisReportResult> deletePerformanceAnalysisReportAsync(DeletePerformanceAnalysisReportRequest request, final AsyncHandler<DeletePerformanceAnalysisReportRequest, DeletePerformanceAnalysisReportResult> asyncHandler) {
        final DeletePerformanceAnalysisReportRequest finalRequest = (DeletePerformanceAnalysisReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePerformanceAnalysisReportResult>(){

            @Override
            public DeletePerformanceAnalysisReportResult call() throws Exception {
                DeletePerformanceAnalysisReportResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeDeletePerformanceAnalysisReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDimensionKeysResult> describeDimensionKeysAsync(DescribeDimensionKeysRequest request) {
        return this.describeDimensionKeysAsync(request, null);
    }

    @Override
    public Future<DescribeDimensionKeysResult> describeDimensionKeysAsync(DescribeDimensionKeysRequest request, final AsyncHandler<DescribeDimensionKeysRequest, DescribeDimensionKeysResult> asyncHandler) {
        final DescribeDimensionKeysRequest finalRequest = (DescribeDimensionKeysRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDimensionKeysResult>(){

            @Override
            public DescribeDimensionKeysResult call() throws Exception {
                DescribeDimensionKeysResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeDescribeDimensionKeys(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDimensionKeyDetailsResult> getDimensionKeyDetailsAsync(GetDimensionKeyDetailsRequest request) {
        return this.getDimensionKeyDetailsAsync(request, null);
    }

    @Override
    public Future<GetDimensionKeyDetailsResult> getDimensionKeyDetailsAsync(GetDimensionKeyDetailsRequest request, final AsyncHandler<GetDimensionKeyDetailsRequest, GetDimensionKeyDetailsResult> asyncHandler) {
        final GetDimensionKeyDetailsRequest finalRequest = (GetDimensionKeyDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDimensionKeyDetailsResult>(){

            @Override
            public GetDimensionKeyDetailsResult call() throws Exception {
                GetDimensionKeyDetailsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeGetDimensionKeyDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPerformanceAnalysisReportResult> getPerformanceAnalysisReportAsync(GetPerformanceAnalysisReportRequest request) {
        return this.getPerformanceAnalysisReportAsync(request, null);
    }

    @Override
    public Future<GetPerformanceAnalysisReportResult> getPerformanceAnalysisReportAsync(GetPerformanceAnalysisReportRequest request, final AsyncHandler<GetPerformanceAnalysisReportRequest, GetPerformanceAnalysisReportResult> asyncHandler) {
        final GetPerformanceAnalysisReportRequest finalRequest = (GetPerformanceAnalysisReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPerformanceAnalysisReportResult>(){

            @Override
            public GetPerformanceAnalysisReportResult call() throws Exception {
                GetPerformanceAnalysisReportResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeGetPerformanceAnalysisReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceMetadataResult> getResourceMetadataAsync(GetResourceMetadataRequest request) {
        return this.getResourceMetadataAsync(request, null);
    }

    @Override
    public Future<GetResourceMetadataResult> getResourceMetadataAsync(GetResourceMetadataRequest request, final AsyncHandler<GetResourceMetadataRequest, GetResourceMetadataResult> asyncHandler) {
        final GetResourceMetadataRequest finalRequest = (GetResourceMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceMetadataResult>(){

            @Override
            public GetResourceMetadataResult call() throws Exception {
                GetResourceMetadataResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeGetResourceMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceMetricsResult> getResourceMetricsAsync(GetResourceMetricsRequest request) {
        return this.getResourceMetricsAsync(request, null);
    }

    @Override
    public Future<GetResourceMetricsResult> getResourceMetricsAsync(GetResourceMetricsRequest request, final AsyncHandler<GetResourceMetricsRequest, GetResourceMetricsResult> asyncHandler) {
        final GetResourceMetricsRequest finalRequest = (GetResourceMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceMetricsResult>(){

            @Override
            public GetResourceMetricsResult call() throws Exception {
                GetResourceMetricsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeGetResourceMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAvailableResourceDimensionsResult> listAvailableResourceDimensionsAsync(ListAvailableResourceDimensionsRequest request) {
        return this.listAvailableResourceDimensionsAsync(request, null);
    }

    @Override
    public Future<ListAvailableResourceDimensionsResult> listAvailableResourceDimensionsAsync(ListAvailableResourceDimensionsRequest request, final AsyncHandler<ListAvailableResourceDimensionsRequest, ListAvailableResourceDimensionsResult> asyncHandler) {
        final ListAvailableResourceDimensionsRequest finalRequest = (ListAvailableResourceDimensionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAvailableResourceDimensionsResult>(){

            @Override
            public ListAvailableResourceDimensionsResult call() throws Exception {
                ListAvailableResourceDimensionsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeListAvailableResourceDimensions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAvailableResourceMetricsResult> listAvailableResourceMetricsAsync(ListAvailableResourceMetricsRequest request) {
        return this.listAvailableResourceMetricsAsync(request, null);
    }

    @Override
    public Future<ListAvailableResourceMetricsResult> listAvailableResourceMetricsAsync(ListAvailableResourceMetricsRequest request, final AsyncHandler<ListAvailableResourceMetricsRequest, ListAvailableResourceMetricsResult> asyncHandler) {
        final ListAvailableResourceMetricsRequest finalRequest = (ListAvailableResourceMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAvailableResourceMetricsResult>(){

            @Override
            public ListAvailableResourceMetricsResult call() throws Exception {
                ListAvailableResourceMetricsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeListAvailableResourceMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPerformanceAnalysisReportsResult> listPerformanceAnalysisReportsAsync(ListPerformanceAnalysisReportsRequest request) {
        return this.listPerformanceAnalysisReportsAsync(request, null);
    }

    @Override
    public Future<ListPerformanceAnalysisReportsResult> listPerformanceAnalysisReportsAsync(ListPerformanceAnalysisReportsRequest request, final AsyncHandler<ListPerformanceAnalysisReportsRequest, ListPerformanceAnalysisReportsResult> asyncHandler) {
        final ListPerformanceAnalysisReportsRequest finalRequest = (ListPerformanceAnalysisReportsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPerformanceAnalysisReportsResult>(){

            @Override
            public ListPerformanceAnalysisReportsResult call() throws Exception {
                ListPerformanceAnalysisReportsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeListPerformanceAnalysisReports(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

